"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const s3 = require("@aws-cdk/aws-s3");
const s3assets = require("@aws-cdk/aws-s3-assets");
const aws_codestar_1 = require("@aws-cdk/aws-codestar");
class Deployment extends cdk.Construct {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const assets = new s3assets.Asset(this, `${id}zip`, {
            path: props.path,
        });
        new aws_codestar_1.GitHubRepository(this, `${id}GitHubRepo}`, {
            contentsBucket: s3.Bucket.fromBucketName(this, `${id}bucket`, assets.s3BucketName),
            contentsKey: assets.s3ObjectKey,
            owner: props.owner,
            repositoryName: props.repositoryName,
            visibility: (_a = props.visibility) !== null && _a !== void 0 ? _a : aws_codestar_1.RepositoryVisibility.PUBLIC,
            accessToken: props.accessToken,
        });
    }
}
exports.Deployment = Deployment;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHFDQUFxQztBQUNyQyxzQ0FBc0M7QUFDdEMsbURBQW1EO0FBQ25ELHdEQUErRTtBQVUvRSxNQUFhLFVBQVcsU0FBUSxHQUFHLENBQUMsU0FBUztJQUMzQyxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQXNCOztRQUNsRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sTUFBTSxHQUFHLElBQUksUUFBUSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsR0FBRyxFQUFFLEtBQUssRUFBRTtZQUNsRCxJQUFJLEVBQUUsS0FBSyxDQUFDLElBQUk7U0FDakIsQ0FBQyxDQUFBO1FBRUYsSUFBSSwrQkFBZ0IsQ0FBQyxJQUFJLEVBQUUsR0FBRyxFQUFFLGFBQWEsRUFBRTtZQUM3QyxjQUFjLEVBQUUsRUFBRSxDQUFDLE1BQU0sQ0FBQyxjQUFjLENBQUMsSUFBSSxFQUFFLEdBQUcsRUFBRSxRQUFRLEVBQUUsTUFBTSxDQUFDLFlBQVksQ0FBQztZQUNsRixXQUFXLEVBQUUsTUFBTSxDQUFDLFdBQVc7WUFDL0IsS0FBSyxFQUFFLEtBQUssQ0FBQyxLQUFLO1lBQ2xCLGNBQWMsRUFBRSxLQUFLLENBQUMsY0FBYztZQUNwQyxVQUFVLFFBQUUsS0FBSyxDQUFDLFVBQVUsbUNBQUksbUNBQW9CLENBQUMsTUFBTTtZQUMzRCxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7U0FDL0IsQ0FBQyxDQUFBO0lBQ0osQ0FBQztDQUNGO0FBakJELGdDQWlCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCAqIGFzIHMzIGZyb20gJ0Bhd3MtY2RrL2F3cy1zMyc7XG5pbXBvcnQgKiBhcyBzM2Fzc2V0cyBmcm9tICdAYXdzLWNkay9hd3MtczMtYXNzZXRzJztcbmltcG9ydCB7IEdpdEh1YlJlcG9zaXRvcnksIFJlcG9zaXRvcnlWaXNpYmlsaXR5IH0gZnJvbSAnQGF3cy1jZGsvYXdzLWNvZGVzdGFyJztcblxuZXhwb3J0IGludGVyZmFjZSBEZXBsb3ltZW50UHJvcHMge1xuICByZWFkb25seSBwYXRoOiBzdHJpbmc7XG4gIHJlYWRvbmx5IG93bmVyOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHJlcG9zaXRvcnlOYW1lOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHZpc2liaWxpdHk/OiBSZXBvc2l0b3J5VmlzaWJpbGl0eTtcbiAgcmVhZG9ubHkgYWNjZXNzVG9rZW46IGNkay5TZWNyZXRWYWx1ZTtcbn1cblxuZXhwb3J0IGNsYXNzIERlcGxveW1lbnQgZXh0ZW5kcyBjZGsuQ29uc3RydWN0IHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBEZXBsb3ltZW50UHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgYXNzZXRzID0gbmV3IHMzYXNzZXRzLkFzc2V0KHRoaXMsIGAke2lkfXppcGAsIHtcbiAgICAgIHBhdGg6IHByb3BzLnBhdGgsXG4gICAgfSlcblxuICAgIG5ldyBHaXRIdWJSZXBvc2l0b3J5KHRoaXMsIGAke2lkfUdpdEh1YlJlcG99YCwge1xuICAgICAgY29udGVudHNCdWNrZXQ6IHMzLkJ1Y2tldC5mcm9tQnVja2V0TmFtZSh0aGlzLCBgJHtpZH1idWNrZXRgLCBhc3NldHMuczNCdWNrZXROYW1lKSxcbiAgICAgIGNvbnRlbnRzS2V5OiBhc3NldHMuczNPYmplY3RLZXksXG4gICAgICBvd25lcjogcHJvcHMub3duZXIsXG4gICAgICByZXBvc2l0b3J5TmFtZTogcHJvcHMucmVwb3NpdG9yeU5hbWUsXG4gICAgICB2aXNpYmlsaXR5OiBwcm9wcy52aXNpYmlsaXR5ID8/IFJlcG9zaXRvcnlWaXNpYmlsaXR5LlBVQkxJQyxcbiAgICAgIGFjY2Vzc1Rva2VuOiBwcm9wcy5hY2Nlc3NUb2tlbixcbiAgICB9KVxuICB9XG59XG4iXX0=