# `cdk-github-import`

Import local file assets into a new GitHub repository

# Usage

```ts
import { Deployment } from 'cdk-github-import';

// create a new github repository pahud/new-repo and import all files from ./lib to it
new Deployment(stack, 'NewImport', {
    path: './lib',
    owner: 'pahud',
    repositoryName: 'new-repo',
    accessToken: cdk.SecretValue.secretsManager('my-github-token', {
      jsonField: 'token',
    }),
})

```

## Private repository

Set `visibility` to `PRIVATE` to create a private GitHub repository.

```ts
visibility: RepositoryVisibility.PRIVATE,
```

