const {
  JsiiProject,
  Semver
} = require('projen');

const AWS_CDK_LATEST_RELEASE = '1.45.0';
const PROJECT_NAME = 'cdk-github-import';
const PROJECT_DESCRIPTION = 'Import local file assets into a new Github repository';

const project = new JsiiProject({
  name: PROJECT_NAME,
  jsiiVersion: Semver.caret('1.5.0'),
  description: PROJECT_DESCRIPTION,
  repository: 'https://github.com/pahud/cdk-github-import.git',
  authorName: 'Pahud Hsieh',
  authorEmail: 'hunhsieh@amazon.com',
  stability: 'experimental',
  devDependencies: {
    '@aws-cdk/assert': Semver.caret(AWS_CDK_LATEST_RELEASE),
    '@types/jest': Semver.caret('25.2.3'),
    '@types/node': Semver.caret('14.0.11'),
    'ts-jest': Semver.caret('25.3.1'),
    'jest': Semver.caret('25.5.0'),
  },
  peerDependencies: {
    constructs: Semver.caret('3.0.3'),
    '@aws-cdk/core': Semver.caret(AWS_CDK_LATEST_RELEASE),
    '@aws-cdk/aws-codestar': Semver.caret(AWS_CDK_LATEST_RELEASE),
    '@aws-cdk/aws-s3': Semver.caret(AWS_CDK_LATEST_RELEASE),
    '@aws-cdk/aws-s3-assets': Semver.caret(AWS_CDK_LATEST_RELEASE),
  },
  dependencies: {
    constructs: Semver.caret('3.0.3'),
    '@aws-cdk/core': Semver.caret(AWS_CDK_LATEST_RELEASE),
    '@aws-cdk/aws-codestar': Semver.caret(AWS_CDK_LATEST_RELEASE),
    '@aws-cdk/aws-s3': Semver.caret(AWS_CDK_LATEST_RELEASE),
    '@aws-cdk/aws-s3-assets': Semver.caret(AWS_CDK_LATEST_RELEASE),
  },
  python: {
    distName: 'cdk-github-import',
    module: 'cdk_github_import'
  }
});

project.addFields({
  'keywords': [
    'cdk',
    'aws',
    'github',
    'import'
  ]
});

project.addFields({
  'awscdkio': {
    'twitter': '@pahudnet',
    'announce': true,
  }
});

project.npmignore.exclude('cdk.out', 'yarn-error.log');


project.synth();
