import { IRole } from '@aws-cdk/aws-iam';
import { IBucket } from '@aws-cdk/aws-s3';
import { BucketDeployment } from '@aws-cdk/aws-s3-deployment';
import { Construct } from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface BucketDeploymentExpiratorProps {
    /**
     * The CDK Bucket Deployment Construct.
     *
     * Required to addDependency
     *
     * @stability stable
     */
    readonly bucketDeployment: BucketDeployment;
    /**
     * The S3 bucket to remove old deployments from.
     *
     * @stability stable
     */
    readonly sourceBucket: IBucket;
    /**
     * The number of old deployments to keep.
     *
     * @default 3
     * @stability stable
     */
    readonly deploymentsToKeep?: number;
    /**
     * Whether or not to remove items without a metadata key.
     *
     * @default false
     * @stability stable
     */
    readonly removeUnmarked?: boolean;
    /**
     * Execution role associated with this function.
     *
     * @default - A role is automatically created
     * @stability stable
     */
    readonly role?: IRole;
    /**
     * The S3 metadata key to look for as a timestamp.
     *
     * @default "deployed"
     * @stability stable
     */
    readonly metaLookupKey?: string;
}
/**
 * @stability stable
 */
export declare class BucketDeploymentExpirator extends Construct {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: BucketDeploymentExpiratorProps);
    private renderSingletonUuid;
}
