"""A web3.py Contract class for the OverloadedMethods contract.

DO NOT EDIT.  This file was generated by pypechain v0.0.40.
See documentation at https://github.com/delvtech/pypechain """

# contracts have PascalCase names
# pylint: disable=invalid-name

# contracts control how many attributes and arguments we have in generated code
# pylint: disable=too-many-instance-attributes
# pylint: disable=too-many-arguments

# we don't need else statement if the other conditionals all have return,
# but it's easier to generate
# pylint: disable=no-else-return

# This file is bound to get very long depending on contract sizes.
# pylint: disable=too-many-lines

# methods are overriden with specific arguments instead of generic *args, **kwargs
# pylint: disable=arguments-differ

# consumers have too many opinions on line length
# pylint: disable=line-too-long


from __future__ import annotations

from typing import Any, NamedTuple, Type, cast, overload

from eth_account.signers.local import LocalAccount
from eth_typing import ABI, ChecksumAddress, HexStr
from hexbytes import HexBytes
from typing_extensions import Self
from web3 import Web3
from web3.contract.contract import Contract, ContractConstructor, ContractFunction, ContractFunctions
from web3.types import BlockIdentifier, StateOverride, TxParams

from pypechain.core import dataclass_to_tuple, rename_returned_types

structs = {}


class OverloadedMethodsDoSomethingContractFunction0(ContractFunction):
    """ContractFunction for the doSomething method."""

    def __call__(self, x: int, s: str) -> OverloadedMethodsDoSomethingContractFunction:  # type: ignore
        super().__call__(dataclass_to_tuple(x), dataclass_to_tuple(s))  # type: ignore
        return cast(OverloadedMethodsDoSomethingContractFunction, self)

    class ReturnValues(NamedTuple):
        """The return named tuple for DoSomething."""

        int_input: int
        arg2: str

    def call(
        self,
        transaction: TxParams | None = None,
        block_identifier: BlockIdentifier = "latest",
        state_override: StateOverride | None = None,
        ccip_read_enabled: bool | None = None,
    ) -> ReturnValues:
        """returns ReturnValues."""
        # Define the expected return types from the smart contract call

        return_types = [int, str]

        # Call the function
        raw_values = super().call(transaction, block_identifier, state_override, ccip_read_enabled)

        return self.ReturnValues(*rename_returned_types(structs, return_types, raw_values))


class OverloadedMethodsDoSomethingContractFunction1(ContractFunction):
    """ContractFunction for the doSomething method."""

    def __call__(self, s: str) -> OverloadedMethodsDoSomethingContractFunction:  # type: ignore
        super().__call__()  # type: ignore
        return cast(OverloadedMethodsDoSomethingContractFunction, self)

    def call(
        self,
        transaction: TxParams | None = None,
        block_identifier: BlockIdentifier = "latest",
        state_override: StateOverride | None = None,
        ccip_read_enabled: bool | None = None,
    ) -> str:
        """returns str."""
        # Define the expected return types from the smart contract call

        return_types = str

        # Call the function
        raw_values = super().call(transaction, block_identifier, state_override, ccip_read_enabled)

        return cast(str, rename_returned_types(structs, return_types, raw_values))


class OverloadedMethodsDoSomethingContractFunction2(ContractFunction):
    """ContractFunction for the doSomething method."""

    def __call__(self, x: int) -> OverloadedMethodsDoSomethingContractFunction:  # type: ignore
        super().__call__()  # type: ignore
        return cast(OverloadedMethodsDoSomethingContractFunction, self)

    def call(
        self,
        transaction: TxParams | None = None,
        block_identifier: BlockIdentifier = "latest",
        state_override: StateOverride | None = None,
        ccip_read_enabled: bool | None = None,
    ) -> int:
        """returns int."""
        # Define the expected return types from the smart contract call

        return_types = int

        # Call the function
        raw_values = super().call(transaction, block_identifier, state_override, ccip_read_enabled)

        return cast(int, rename_returned_types(structs, return_types, raw_values))


class OverloadedMethodsDoSomethingContractFunction3(ContractFunction):
    """ContractFunction for the doSomething method."""

    def __call__(self, x: int, y: int) -> OverloadedMethodsDoSomethingContractFunction:  # type: ignore
        super().__call__(dataclass_to_tuple(x), dataclass_to_tuple(y))  # type: ignore
        return cast(OverloadedMethodsDoSomethingContractFunction, self)

    def call(
        self,
        transaction: TxParams | None = None,
        block_identifier: BlockIdentifier = "latest",
        state_override: StateOverride | None = None,
        ccip_read_enabled: bool | None = None,
    ) -> int:
        """returns int."""
        # Define the expected return types from the smart contract call

        return_types = int

        # Call the function
        raw_values = super().call(transaction, block_identifier, state_override, ccip_read_enabled)

        return cast(int, rename_returned_types(structs, return_types, raw_values))


class OverloadedMethodsDoSomethingContractFunction(ContractFunction):
    """ContractFunction for the doSomething method."""

    # super() call methods are generic, while our version adds values & types
    # pylint: disable=arguments-differ# disable this warning when there is overloading
    # pylint: disable=function-redefined

    @overload
    def __call__(self, x: int, s: str) -> OverloadedMethodsDoSomethingContractFunction0:  # type: ignore
        ...

    @overload
    def __call__(self, s: str) -> OverloadedMethodsDoSomethingContractFunction1:  # type: ignore
        ...

    @overload
    def __call__(self, x: int) -> OverloadedMethodsDoSomethingContractFunction2:  # type: ignore
        ...

    @overload
    def __call__(self, x: int, y: int) -> OverloadedMethodsDoSomethingContractFunction3:  # type: ignore
        ...

    def __call__(self, *args) -> OverloadedMethodsDoSomethingContractFunction:  # type: ignore
        clone = super().__call__(*(dataclass_to_tuple(arg) for arg in args))
        self.kwargs = clone.kwargs
        self.args = clone.args
        return self  # type: ignore


class OverloadedMethodsContractFunctions(ContractFunctions):
    """ContractFunctions for the OverloadedMethods contract."""

    doSomething: OverloadedMethodsDoSomethingContractFunction

    def __init__(
        self,
        abi: ABI,
        w3: "Web3",
        address: ChecksumAddress | None = None,
        decode_tuples: bool | None = False,
    ) -> None:
        super().__init__(abi, w3, address, decode_tuples)
        self.doSomething = OverloadedMethodsDoSomethingContractFunction.factory(
            "doSomething",
            w3=w3,
            contract_abi=abi,
            address=address,
            decode_tuples=decode_tuples,
            abi_element_identifier="doSomething",
        )


overloadedmethods_abi: ABI = cast(
    ABI,
    [
        {
            "type": "function",
            "name": "doSomething",
            "inputs": [
                {"name": "x", "type": "uint256", "internalType": "uint256"},
                {"name": "s", "type": "string", "internalType": "string"},
            ],
            "outputs": [
                {"name": "int_input", "type": "uint256", "internalType": "uint256"},
                {"name": "", "type": "string", "internalType": "string"},
            ],
            "stateMutability": "pure",
        },
        {
            "type": "function",
            "name": "doSomething",
            "inputs": [{"name": "s", "type": "string", "internalType": "string"}],
            "outputs": [{"name": "", "type": "string", "internalType": "string"}],
            "stateMutability": "pure",
        },
        {
            "type": "function",
            "name": "doSomething",
            "inputs": [{"name": "x", "type": "uint256", "internalType": "uint256"}],
            "outputs": [{"name": "", "type": "uint256", "internalType": "uint256"}],
            "stateMutability": "pure",
        },
        {
            "type": "function",
            "name": "doSomething",
            "inputs": [
                {"name": "x", "type": "uint256", "internalType": "uint256"},
                {"name": "y", "type": "uint256", "internalType": "uint256"},
            ],
            "outputs": [{"name": "added", "type": "uint256", "internalType": "uint256"}],
            "stateMutability": "pure",
        },
    ],
)


class OverloadedMethodsContract(Contract):
    """A web3.py Contract class for the OverloadedMethods contract."""

    abi: ABI = overloadedmethods_abi
    # We change `bytecode` as needed for linking, but keep
    # `_raw_bytecode` unchanged as an original copy.
    # pylint: disable=line-too-long
    _raw_bytecode: HexStr | None = HexStr(
        "0x608060405234801561001057600080fd5b5061033c806100206000396000f3fe608060405234801561001057600080fd5b506004361061004c5760003560e01c80633b6c27c4146100515780638ae3048e1461007a578063a6b206bf14610098578063b2dd1d79146100b9575b600080fd5b61006361005f366004610195565b9091565b604051610071929190610222565b60405180910390f35b61008b610088366004610243565b90565b6040516100719190610278565b6100ab6100a636600461028b565b6100cc565b604051908152602001610071565b6100ab6100c73660046102a4565b6100df565b60006100d98260026102dc565b92915050565b60006100eb82846102f3565b9392505050565b634e487b7160e01b600052604160045260246000fd5b600082601f83011261011957600080fd5b813567ffffffffffffffff80821115610134576101346100f2565b604051601f8301601f19908116603f0116810190828211818310171561015c5761015c6100f2565b8160405283815286602085880101111561017557600080fd5b836020870160208301376000602085830101528094505050505092915050565b600080604083850312156101a857600080fd5b82359150602083013567ffffffffffffffff8111156101c657600080fd5b6101d285828601610108565b9150509250929050565b6000815180845260005b81811015610202576020818501810151868301820152016101e6565b506000602082860101526020601f19601f83011685010191505092915050565b82815260406020820152600061023b60408301846101dc565b949350505050565b60006020828403121561025557600080fd5b813567ffffffffffffffff81111561026c57600080fd5b61023b84828501610108565b6020815260006100eb60208301846101dc565b60006020828403121561029d57600080fd5b5035919050565b600080604083850312156102b757600080fd5b50508035926020909101359150565b634e487b7160e01b600052601160045260246000fd5b80820281158282048414176100d9576100d96102c6565b808201808211156100d9576100d96102c656fea2646970667358221220b2ac531af898c14ca1c2bf29695116e40807da6cfffc0292534640d2d6903f4664736f6c63430008160033"
    )

    def __init__(self, address: ChecksumAddress | None = None) -> None:
        # Initialize parent Contract class
        super().__init__(address=address)
        self.functions = OverloadedMethodsContractFunctions(overloadedmethods_abi, self.w3, address)  # type: ignore

    functions: OverloadedMethodsContractFunctions

    @classmethod
    def constructor(cls) -> ContractConstructor:  # type: ignore
        """Creates a transaction with the contract's constructor function.

        Parameters
        ----------

        w3 : Web3
            A web3 instance.
        account : LocalAccount
            The account to use to deploy the contract.

        Returns
        -------
        Self
            A deployed instance of the contract.

        """
        cls.bytecode = cls._raw_bytecode
        if cls.bytecode is not None:

            # bytecode needs to be in hex for web3
            cls.bytecode = HexBytes(cls.bytecode)

        return super().constructor()

    @classmethod
    def deploy(cls, w3: Web3, account: LocalAccount | ChecksumAddress) -> Self:
        """Deploys an instance of the contract.

        Parameters
        ----------
        w3 : Web3
            A web3 instance.
        account : LocalAccount
            The account to use to deploy the contract.

        Returns
        -------
        Self
            A deployed instance of the contract.
        """
        deployer = cls.factory(w3=w3)
        constructor_fn = deployer.constructor()

        # if an address is supplied, try to use a web3 default account
        if isinstance(account, str):
            tx_hash = constructor_fn.transact({"from": account})
            tx_receipt = w3.eth.wait_for_transaction_receipt(tx_hash)

            deployed_contract = deployer(address=tx_receipt.contractAddress)  # type: ignore
            return deployed_contract

        # otherwise use the account provided.
        deployment_tx = constructor_fn.build_transaction()
        current_nonce = w3.eth.get_transaction_count(account.address, "pending")
        deployment_tx.update({"nonce": current_nonce})

        # Sign the transaction with local account private key
        signed_tx = account.sign_transaction(deployment_tx)

        # Send the signed transaction and wait for receipt
        tx_hash = w3.eth.send_raw_transaction(signed_tx.raw_transaction)
        tx_receipt = w3.eth.wait_for_transaction_receipt(tx_hash)

        deployed_contract = deployer(address=tx_receipt.contractAddress)  # type: ignore
        return deployed_contract

    @classmethod
    def factory(cls, w3: Web3, class_name: str | None = None, **kwargs: Any) -> Type[Self]:
        """Initializes the contract object.

        Parameters
        ----------
        w3 : Web3
            A web3 instance.
        class_name: str | None
            The instance class name.

        Returns
        -------
        Self
            An instance of the contract class.
        """
        contract = super().factory(w3, class_name, **kwargs)
        contract.functions = OverloadedMethodsContractFunctions(overloadedmethods_abi, w3, None)

        return contract
