"""A web3.py Contract class for the Example contract.

DO NOT EDIT.  This file was generated by pypechain v0.0.40.
See documentation at https://github.com/delvtech/pypechain """

# contracts have PascalCase names
# pylint: disable=invalid-name

# contracts control how many attributes and arguments we have in generated code
# pylint: disable=too-many-instance-attributes
# pylint: disable=too-many-arguments

# we don't need else statement if the other conditionals all have return,
# but it's easier to generate
# pylint: disable=no-else-return

# This file is bound to get very long depending on contract sizes.
# pylint: disable=too-many-lines

# methods are overriden with specific arguments instead of generic *args, **kwargs
# pylint: disable=arguments-differ

# consumers have too many opinions on line length
# pylint: disable=line-too-long


from __future__ import annotations

from typing import Any, Iterable, NamedTuple, Sequence, Type, cast

from eth_abi.codec import ABICodec
from eth_abi.registry import registry as default_registry
from eth_account.signers.local import LocalAccount
from eth_typing import ABI, ABIFunction, ChecksumAddress, HexStr
from hexbytes import HexBytes
from typing_extensions import Self
from web3 import Web3
from web3._utils.filters import LogFilter
from web3.contract.contract import (
    Contract,
    ContractConstructor,
    ContractEvent,
    ContractEvents,
    ContractFunction,
    ContractFunctions,
)
from web3.types import BlockIdentifier, StateOverride, TxParams

from pypechain.core import dataclass_to_tuple, get_abi_input_types, rename_returned_types

from .ExampleTypes import FlipEvent, FlopEvent, InnerStruct, NestedStruct, SimpleStruct

structs = {
    "SimpleStruct": SimpleStruct,
    "InnerStruct": InnerStruct,
    "NestedStruct": NestedStruct,
}


class ExampleFlipFlopContractFunction(ContractFunction):
    """ContractFunction for the flipFlop method."""

    class ReturnValues(NamedTuple):
        """The return named tuple for FlipFlop."""

        flop: int
        flip: int

    def __call__(self, flip: int, flop: int) -> ExampleFlipFlopContractFunction:  # type: ignore
        clone = super().__call__(dataclass_to_tuple(flip), dataclass_to_tuple(flop))
        self.kwargs = clone.kwargs
        self.args = clone.args
        return self

    def call(
        self,
        transaction: TxParams | None = None,
        block_identifier: BlockIdentifier = "latest",
        state_override: StateOverride | None = None,
        ccip_read_enabled: bool | None = None,
    ) -> ReturnValues:
        """returns ReturnValues."""
        # Define the expected return types from the smart contract call

        return_types = [int, int]

        # Call the function

        raw_values = super().call(transaction, block_identifier, state_override, ccip_read_enabled)
        return self.ReturnValues(*rename_returned_types(structs, return_types, raw_values))


class ExampleGuessALetterContractFunction(ContractFunction):
    """ContractFunction for the guessALetter method."""

    def __call__(self, guess: int) -> ExampleGuessALetterContractFunction:  # type: ignore
        clone = super().__call__(dataclass_to_tuple(guess))
        self.kwargs = clone.kwargs
        self.args = clone.args
        return self

    def call(
        self,
        transaction: TxParams | None = None,
        block_identifier: BlockIdentifier = "latest",
        state_override: StateOverride | None = None,
        ccip_read_enabled: bool | None = None,
    ) -> None:
        """returns None."""
        # Define the expected return types from the smart contract call

        # Call the function


class ExampleMixStructsAndPrimitivesContractFunction(ContractFunction):
    """ContractFunction for the mixStructsAndPrimitives method."""

    class ReturnValues(NamedTuple):
        """The return named tuple for MixStructsAndPrimitives."""

        simpleStruct: SimpleStruct
        arg2: NestedStruct
        arg3: int
        name: str
        YesOrNo: bool

    def __call__(self) -> ExampleMixStructsAndPrimitivesContractFunction:  # type: ignore
        clone = super().__call__()
        self.kwargs = clone.kwargs
        self.args = clone.args
        return self

    def call(
        self,
        transaction: TxParams | None = None,
        block_identifier: BlockIdentifier = "latest",
        state_override: StateOverride | None = None,
        ccip_read_enabled: bool | None = None,
    ) -> ReturnValues:
        """returns ReturnValues."""
        # Define the expected return types from the smart contract call

        return_types = [SimpleStruct, NestedStruct, int, str, bool]

        # Call the function

        raw_values = super().call(transaction, block_identifier, state_override, ccip_read_enabled)
        return self.ReturnValues(*rename_returned_types(structs, return_types, raw_values))


class ExampleNamedSingleStructContractFunction(ContractFunction):
    """ContractFunction for the namedSingleStruct method."""

    def __call__(self) -> ExampleNamedSingleStructContractFunction:  # type: ignore
        clone = super().__call__()
        self.kwargs = clone.kwargs
        self.args = clone.args
        return self

    def call(
        self,
        transaction: TxParams | None = None,
        block_identifier: BlockIdentifier = "latest",
        state_override: StateOverride | None = None,
        ccip_read_enabled: bool | None = None,
    ) -> SimpleStruct:
        """returns SimpleStruct."""
        # Define the expected return types from the smart contract call

        return_types = SimpleStruct

        # Call the function

        raw_values = super().call(transaction, block_identifier, state_override, ccip_read_enabled)
        return cast(SimpleStruct, rename_returned_types(structs, return_types, raw_values))


class ExampleNamedTwoMixedStructsContractFunction(ContractFunction):
    """ContractFunction for the namedTwoMixedStructs method."""

    class ReturnValues(NamedTuple):
        """The return named tuple for NamedTwoMixedStructs."""

        simpleStruct: SimpleStruct
        nestedStruct: NestedStruct

    def __call__(self) -> ExampleNamedTwoMixedStructsContractFunction:  # type: ignore
        clone = super().__call__()
        self.kwargs = clone.kwargs
        self.args = clone.args
        return self

    def call(
        self,
        transaction: TxParams | None = None,
        block_identifier: BlockIdentifier = "latest",
        state_override: StateOverride | None = None,
        ccip_read_enabled: bool | None = None,
    ) -> ReturnValues:
        """returns ReturnValues."""
        # Define the expected return types from the smart contract call

        return_types = [SimpleStruct, NestedStruct]

        # Call the function

        raw_values = super().call(transaction, block_identifier, state_override, ccip_read_enabled)
        return self.ReturnValues(*rename_returned_types(structs, return_types, raw_values))


class ExampleSingleNestedStructContractFunction(ContractFunction):
    """ContractFunction for the singleNestedStruct method."""

    def __call__(self, nestedStruct: NestedStruct) -> ExampleSingleNestedStructContractFunction:  # type: ignore
        clone = super().__call__(dataclass_to_tuple(nestedStruct))
        self.kwargs = clone.kwargs
        self.args = clone.args
        return self

    def call(
        self,
        transaction: TxParams | None = None,
        block_identifier: BlockIdentifier = "latest",
        state_override: StateOverride | None = None,
        ccip_read_enabled: bool | None = None,
    ) -> NestedStruct:
        """returns NestedStruct."""
        # Define the expected return types from the smart contract call

        return_types = NestedStruct

        # Call the function

        raw_values = super().call(transaction, block_identifier, state_override, ccip_read_enabled)
        return cast(NestedStruct, rename_returned_types(structs, return_types, raw_values))


class ExampleSingleSimpleStructContractFunction(ContractFunction):
    """ContractFunction for the singleSimpleStruct method."""

    def __call__(self, simpleStruct: SimpleStruct) -> ExampleSingleSimpleStructContractFunction:  # type: ignore
        clone = super().__call__(dataclass_to_tuple(simpleStruct))
        self.kwargs = clone.kwargs
        self.args = clone.args
        return self

    def call(
        self,
        transaction: TxParams | None = None,
        block_identifier: BlockIdentifier = "latest",
        state_override: StateOverride | None = None,
        ccip_read_enabled: bool | None = None,
    ) -> SimpleStruct:
        """returns SimpleStruct."""
        # Define the expected return types from the smart contract call

        return_types = SimpleStruct

        # Call the function

        raw_values = super().call(transaction, block_identifier, state_override, ccip_read_enabled)
        return cast(SimpleStruct, rename_returned_types(structs, return_types, raw_values))


class ExampleTwoMixedStructsContractFunction(ContractFunction):
    """ContractFunction for the twoMixedStructs method."""

    class ReturnValues(NamedTuple):
        """The return named tuple for TwoMixedStructs."""

        arg1: SimpleStruct
        arg2: NestedStruct

    def __call__(self) -> ExampleTwoMixedStructsContractFunction:  # type: ignore
        clone = super().__call__()
        self.kwargs = clone.kwargs
        self.args = clone.args
        return self

    def call(
        self,
        transaction: TxParams | None = None,
        block_identifier: BlockIdentifier = "latest",
        state_override: StateOverride | None = None,
        ccip_read_enabled: bool | None = None,
    ) -> ReturnValues:
        """returns ReturnValues."""
        # Define the expected return types from the smart contract call

        return_types = [SimpleStruct, NestedStruct]

        # Call the function

        raw_values = super().call(transaction, block_identifier, state_override, ccip_read_enabled)
        return self.ReturnValues(*rename_returned_types(structs, return_types, raw_values))


class ExampleTwoSimpleStructsContractFunction(ContractFunction):
    """ContractFunction for the twoSimpleStructs method."""

    class ReturnValues(NamedTuple):
        """The return named tuple for TwoSimpleStructs."""

        arg1: SimpleStruct
        arg2: SimpleStruct

    def __call__(self) -> ExampleTwoSimpleStructsContractFunction:  # type: ignore
        clone = super().__call__()
        self.kwargs = clone.kwargs
        self.args = clone.args
        return self

    def call(
        self,
        transaction: TxParams | None = None,
        block_identifier: BlockIdentifier = "latest",
        state_override: StateOverride | None = None,
        ccip_read_enabled: bool | None = None,
    ) -> ReturnValues:
        """returns ReturnValues."""
        # Define the expected return types from the smart contract call

        return_types = [SimpleStruct, SimpleStruct]

        # Call the function

        raw_values = super().call(transaction, block_identifier, state_override, ccip_read_enabled)
        return self.ReturnValues(*rename_returned_types(structs, return_types, raw_values))


class ExampleVecOfStructContractFunction(ContractFunction):
    """ContractFunction for the vecOfStruct method."""

    def __call__(self, inVecSimpleStruct: list[SimpleStruct]) -> ExampleVecOfStructContractFunction:  # type: ignore
        clone = super().__call__(dataclass_to_tuple(inVecSimpleStruct))
        self.kwargs = clone.kwargs
        self.args = clone.args
        return self

    def call(
        self,
        transaction: TxParams | None = None,
        block_identifier: BlockIdentifier = "latest",
        state_override: StateOverride | None = None,
        ccip_read_enabled: bool | None = None,
    ) -> list[SimpleStruct]:
        """returns list[SimpleStruct]."""
        # Define the expected return types from the smart contract call

        return_types = list[SimpleStruct]

        # Call the function

        raw_values = super().call(transaction, block_identifier, state_override, ccip_read_enabled)
        return cast(list[SimpleStruct], rename_returned_types(structs, return_types, raw_values))


class ExampleContractFunctions(ContractFunctions):
    """ContractFunctions for the Example contract."""

    flipFlop: ExampleFlipFlopContractFunction

    guessALetter: ExampleGuessALetterContractFunction

    mixStructsAndPrimitives: ExampleMixStructsAndPrimitivesContractFunction

    namedSingleStruct: ExampleNamedSingleStructContractFunction

    namedTwoMixedStructs: ExampleNamedTwoMixedStructsContractFunction

    singleNestedStruct: ExampleSingleNestedStructContractFunction

    singleSimpleStruct: ExampleSingleSimpleStructContractFunction

    twoMixedStructs: ExampleTwoMixedStructsContractFunction

    twoSimpleStructs: ExampleTwoSimpleStructsContractFunction

    vecOfStruct: ExampleVecOfStructContractFunction

    def __init__(
        self,
        abi: ABI,
        w3: "Web3",
        address: ChecksumAddress | None = None,
        decode_tuples: bool | None = False,
    ) -> None:
        super().__init__(abi, w3, address, decode_tuples)
        self.flipFlop = ExampleFlipFlopContractFunction.factory(
            "flipFlop",
            w3=w3,
            contract_abi=abi,
            address=address,
            decode_tuples=decode_tuples,
            abi_element_identifier="flipFlop",
        )
        self.guessALetter = ExampleGuessALetterContractFunction.factory(
            "guessALetter",
            w3=w3,
            contract_abi=abi,
            address=address,
            decode_tuples=decode_tuples,
            abi_element_identifier="guessALetter",
        )
        self.mixStructsAndPrimitives = ExampleMixStructsAndPrimitivesContractFunction.factory(
            "mixStructsAndPrimitives",
            w3=w3,
            contract_abi=abi,
            address=address,
            decode_tuples=decode_tuples,
            abi_element_identifier="mixStructsAndPrimitives",
        )
        self.namedSingleStruct = ExampleNamedSingleStructContractFunction.factory(
            "namedSingleStruct",
            w3=w3,
            contract_abi=abi,
            address=address,
            decode_tuples=decode_tuples,
            abi_element_identifier="namedSingleStruct",
        )
        self.namedTwoMixedStructs = ExampleNamedTwoMixedStructsContractFunction.factory(
            "namedTwoMixedStructs",
            w3=w3,
            contract_abi=abi,
            address=address,
            decode_tuples=decode_tuples,
            abi_element_identifier="namedTwoMixedStructs",
        )
        self.singleNestedStruct = ExampleSingleNestedStructContractFunction.factory(
            "singleNestedStruct",
            w3=w3,
            contract_abi=abi,
            address=address,
            decode_tuples=decode_tuples,
            abi_element_identifier="singleNestedStruct",
        )
        self.singleSimpleStruct = ExampleSingleSimpleStructContractFunction.factory(
            "singleSimpleStruct",
            w3=w3,
            contract_abi=abi,
            address=address,
            decode_tuples=decode_tuples,
            abi_element_identifier="singleSimpleStruct",
        )
        self.twoMixedStructs = ExampleTwoMixedStructsContractFunction.factory(
            "twoMixedStructs",
            w3=w3,
            contract_abi=abi,
            address=address,
            decode_tuples=decode_tuples,
            abi_element_identifier="twoMixedStructs",
        )
        self.twoSimpleStructs = ExampleTwoSimpleStructsContractFunction.factory(
            "twoSimpleStructs",
            w3=w3,
            contract_abi=abi,
            address=address,
            decode_tuples=decode_tuples,
            abi_element_identifier="twoSimpleStructs",
        )
        self.vecOfStruct = ExampleVecOfStructContractFunction.factory(
            "vecOfStruct",
            w3=w3,
            contract_abi=abi,
            address=address,
            decode_tuples=decode_tuples,
            abi_element_identifier="vecOfStruct",
        )


class ExampleFlipContractEvent(ContractEvent):
    """ContractEvent for Flip."""

    # super() get_logs and create_filter methods are generic, while our version adds values & types
    # pylint: disable=arguments-differ

    # @combomethod destroys return types, so we are redefining functions as both class and instance
    # pylint: disable=function-redefined

    # pylint: disable=useless-parent-delegation
    def __init__(self, *argument_names: tuple[str]) -> None:
        super().__init__(*argument_names)

    # We ignore types here for function redefinition
    def get_typed_logs(  # type: ignore
        self: "ExampleFlipContractEvent",
        argument_filters: dict[str, Any] | None = None,
        from_block: BlockIdentifier | None = None,
        to_block: BlockIdentifier | None = None,
        block_hash: HexBytes | None = None,
    ) -> Iterable[FlipEvent]:
        """Extension of `get_logs` that return a typed dataclass of the event."""
        abi_events = super().get_logs(
            argument_filters=argument_filters, from_block=from_block, to_block=to_block, block_hash=block_hash
        )
        # TODO there may be issues with this function if the user uses a middleware that changes event structure.
        return [
            FlipEvent(
                log_index=abi_event.logIndex,
                transaction_index=abi_event.transactionIndex,
                transaction_hash=abi_event.transactionHash,
                address=abi_event.address,
                block_hash=abi_event.blockHash,
                block_number=abi_event.blockNumber,
                args=FlipEvent.FlipEventArgs(
                    flip=abi_event.args["flip"],
                ),
            )
            for abi_event in abi_events
        ]

    @classmethod
    # We ignore types here for function redefinition
    def get_typed_logs(  # type: ignore
        cls: Type["ExampleFlipContractEvent"],
        argument_filters: dict[str, Any] | None = None,
        from_block: BlockIdentifier | None = None,
        to_block: BlockIdentifier | None = None,
        block_hash: HexBytes | None = None,
    ) -> Iterable[FlipEvent]:
        """Extension of `get_logs` that return a typed dataclass of the event."""
        abi_events = super().get_logs(
            argument_filters=argument_filters, from_block=from_block, to_block=to_block, block_hash=block_hash
        )
        # TODO there may be issues with this function if the user uses a middleware that changes event structure.
        return [
            FlipEvent(
                log_index=abi_event.logIndex,
                transaction_index=abi_event.transactionIndex,
                transaction_hash=abi_event.transactionHash,
                address=abi_event.address,
                block_hash=abi_event.blockHash,
                block_number=abi_event.blockNumber,
                args=FlipEvent.FlipEventArgs(
                    flip=abi_event.args["flip"],
                ),
            )
            for abi_event in abi_events
        ]

    def create_filter(  # type: ignore
        self: "ExampleFlipContractEvent",
        *,  # PEP 3102
        argument_filters: dict[str, Any] | None = None,
        from_block: BlockIdentifier | None = None,
        to_block: BlockIdentifier = "latest",
        address: ChecksumAddress | None = None,
        topics: Sequence[Any] | None = None,
    ) -> LogFilter:
        return cast(
            LogFilter,
            super().create_filter(
                argument_filters=argument_filters,
                from_block=from_block,
                to_block=to_block,
                address=address,
                topics=topics,
            ),
        )

    @classmethod
    def create_filter(  # type: ignore
        cls: Type["ExampleFlipContractEvent"],
        *,  # PEP 3102
        argument_filters: dict[str, Any] | None = None,
        from_block: BlockIdentifier | None = None,
        to_block: BlockIdentifier = "latest",
        address: ChecksumAddress | None = None,
        topics: Sequence[Any] | None = None,
    ) -> LogFilter:
        return cast(
            LogFilter,
            super().create_filter(
                argument_filters=argument_filters,
                from_block=from_block,
                to_block=to_block,
                address=address,
                topics=topics,
            ),
        )


class ExampleFlopContractEvent(ContractEvent):
    """ContractEvent for Flop."""

    # super() get_logs and create_filter methods are generic, while our version adds values & types
    # pylint: disable=arguments-differ

    # @combomethod destroys return types, so we are redefining functions as both class and instance
    # pylint: disable=function-redefined

    # pylint: disable=useless-parent-delegation
    def __init__(self, *argument_names: tuple[str]) -> None:
        super().__init__(*argument_names)

    # We ignore types here for function redefinition
    def get_typed_logs(  # type: ignore
        self: "ExampleFlopContractEvent",
        argument_filters: dict[str, Any] | None = None,
        from_block: BlockIdentifier | None = None,
        to_block: BlockIdentifier | None = None,
        block_hash: HexBytes | None = None,
    ) -> Iterable[FlopEvent]:
        """Extension of `get_logs` that return a typed dataclass of the event."""
        abi_events = super().get_logs(
            argument_filters=argument_filters, from_block=from_block, to_block=to_block, block_hash=block_hash
        )
        # TODO there may be issues with this function if the user uses a middleware that changes event structure.
        return [
            FlopEvent(
                log_index=abi_event.logIndex,
                transaction_index=abi_event.transactionIndex,
                transaction_hash=abi_event.transactionHash,
                address=abi_event.address,
                block_hash=abi_event.blockHash,
                block_number=abi_event.blockNumber,
                args=FlopEvent.FlopEventArgs(
                    flop=abi_event.args["flop"],
                ),
            )
            for abi_event in abi_events
        ]

    @classmethod
    # We ignore types here for function redefinition
    def get_typed_logs(  # type: ignore
        cls: Type["ExampleFlopContractEvent"],
        argument_filters: dict[str, Any] | None = None,
        from_block: BlockIdentifier | None = None,
        to_block: BlockIdentifier | None = None,
        block_hash: HexBytes | None = None,
    ) -> Iterable[FlopEvent]:
        """Extension of `get_logs` that return a typed dataclass of the event."""
        abi_events = super().get_logs(
            argument_filters=argument_filters, from_block=from_block, to_block=to_block, block_hash=block_hash
        )
        # TODO there may be issues with this function if the user uses a middleware that changes event structure.
        return [
            FlopEvent(
                log_index=abi_event.logIndex,
                transaction_index=abi_event.transactionIndex,
                transaction_hash=abi_event.transactionHash,
                address=abi_event.address,
                block_hash=abi_event.blockHash,
                block_number=abi_event.blockNumber,
                args=FlopEvent.FlopEventArgs(
                    flop=abi_event.args["flop"],
                ),
            )
            for abi_event in abi_events
        ]

    def create_filter(  # type: ignore
        self: "ExampleFlopContractEvent",
        *,  # PEP 3102
        argument_filters: dict[str, Any] | None = None,
        from_block: BlockIdentifier | None = None,
        to_block: BlockIdentifier = "latest",
        address: ChecksumAddress | None = None,
        topics: Sequence[Any] | None = None,
    ) -> LogFilter:
        return cast(
            LogFilter,
            super().create_filter(
                argument_filters=argument_filters,
                from_block=from_block,
                to_block=to_block,
                address=address,
                topics=topics,
            ),
        )

    @classmethod
    def create_filter(  # type: ignore
        cls: Type["ExampleFlopContractEvent"],
        *,  # PEP 3102
        argument_filters: dict[str, Any] | None = None,
        from_block: BlockIdentifier | None = None,
        to_block: BlockIdentifier = "latest",
        address: ChecksumAddress | None = None,
        topics: Sequence[Any] | None = None,
    ) -> LogFilter:
        return cast(
            LogFilter,
            super().create_filter(
                argument_filters=argument_filters,
                from_block=from_block,
                to_block=to_block,
                address=address,
                topics=topics,
            ),
        )


class ExampleContractEvents(ContractEvents):
    """ContractEvents for the Example contract."""

    Flip: ExampleFlipContractEvent

    Flop: ExampleFlopContractEvent

    def __init__(
        self,
        abi: ABI,
        w3: "Web3",
        address: ChecksumAddress | None = None,
    ) -> None:
        super().__init__(abi, w3, address)
        self.Flip = cast(
            ExampleFlipContractEvent,
            ExampleFlipContractEvent.factory("Flip", w3=w3, contract_abi=abi, address=address, event_name="Flip"),
        )
        self.Flop = cast(
            ExampleFlopContractEvent,
            ExampleFlopContractEvent.factory("Flop", w3=w3, contract_abi=abi, address=address, event_name="Flop"),
        )


class ExampleWrongChoiceContractError:
    """ContractError for WrongChoice."""

    # @combomethod destroys return types, so we are redefining functions as both class and instance
    # pylint: disable=function-redefined

    # 4 byte error selector
    selector: str
    # error signature, i.e. CustomError(uint256,bool)
    signature: str

    # pylint: disable=useless-parent-delegation
    def __init__(
        self: "ExampleWrongChoiceContractError",
    ) -> None:
        self.selector = "0xc13b30d4"
        self.signature = "WrongChoice(uint8,string)"

    def decode_error_data(  # type: ignore
        self: "ExampleWrongChoiceContractError",
        data: HexBytes,
        # TODO: instead of returning a tuple, return a dataclass with the input names and types just like we do for functions
    ) -> tuple[Any, ...]:
        """Decodes error data returns from a smart contract."""
        error_abi = cast(
            ABIFunction,
            [item for item in example_abi if item.get("name") == "WrongChoice" and item.get("type") == "error"][0],
        )
        types = get_abi_input_types(error_abi)
        abi_codec = ABICodec(default_registry)
        decoded = abi_codec.decode(types, data)
        return decoded

    @classmethod
    def decode_error_data(  # type: ignore
        cls: Type["ExampleWrongChoiceContractError"],
        data: HexBytes,
    ) -> tuple[Any, ...]:
        """Decodes error data returns from a smart contract."""
        error_abi = cast(
            ABIFunction,
            [item for item in example_abi if item.get("name") == "WrongChoice" and item.get("type") == "error"][0],
        )
        types = get_abi_input_types(error_abi)
        abi_codec = ABICodec(default_registry)
        decoded = abi_codec.decode(types, data)
        return decoded


class ExampleContractErrors:
    """ContractErrors for the Example contract."""

    WrongChoice: ExampleWrongChoiceContractError

    def __init__(
        self,
    ) -> None:
        self.WrongChoice = ExampleWrongChoiceContractError()

        self._all = [
            self.WrongChoice,
        ]

    def decode_custom_error(self, data: str) -> tuple[Any, ...]:
        """Decodes a custom contract error."""
        selector = data[:10]
        for err in self._all:
            if err.selector == selector:
                return err.decode_error_data(HexBytes(data[10:]))

        raise ValueError(f"Example does not have a selector matching {selector}")


example_abi: ABI = cast(
    ABI,
    [
        {
            "type": "constructor",
            "inputs": [{"name": "name", "type": "string", "internalType": "string"}],
            "stateMutability": "nonpayable",
        },
        {
            "type": "function",
            "name": "flipFlop",
            "inputs": [
                {"name": "flip", "type": "uint256", "internalType": "uint256"},
                {"name": "flop", "type": "uint256", "internalType": "uint256"},
            ],
            "outputs": [
                {"name": "_flop", "type": "uint256", "internalType": "uint256"},
                {"name": "_flip", "type": "uint256", "internalType": "uint256"},
            ],
            "stateMutability": "nonpayable",
        },
        {
            "type": "function",
            "name": "guessALetter",
            "inputs": [{"name": "guess", "type": "uint8", "internalType": "enum Example.Letters"}],
            "outputs": [],
            "stateMutability": "pure",
        },
        {
            "type": "function",
            "name": "mixStructsAndPrimitives",
            "inputs": [],
            "outputs": [
                {
                    "name": "simpleStruct",
                    "type": "tuple",
                    "internalType": "struct Example.SimpleStruct",
                    "components": [
                        {"name": "intVal", "type": "uint256", "internalType": "uint256"},
                        {"name": "strVal", "type": "string", "internalType": "string"},
                    ],
                },
                {
                    "name": "",
                    "type": "tuple",
                    "internalType": "struct Example.NestedStruct",
                    "components": [
                        {"name": "intVal", "type": "uint256", "internalType": "uint256"},
                        {"name": "strVal", "type": "string", "internalType": "string"},
                        {
                            "name": "innerStruct",
                            "type": "tuple",
                            "internalType": "struct Example.InnerStruct",
                            "components": [{"name": "boolVal", "type": "bool", "internalType": "bool"}],
                        },
                    ],
                },
                {"name": "", "type": "uint256", "internalType": "uint256"},
                {"name": "_name", "type": "string", "internalType": "string"},
                {"name": "YesOrNo", "type": "bool", "internalType": "bool"},
            ],
            "stateMutability": "pure",
        },
        {
            "type": "function",
            "name": "namedSingleStruct",
            "inputs": [],
            "outputs": [
                {
                    "name": "struct1",
                    "type": "tuple",
                    "internalType": "struct Example.SimpleStruct",
                    "components": [
                        {"name": "intVal", "type": "uint256", "internalType": "uint256"},
                        {"name": "strVal", "type": "string", "internalType": "string"},
                    ],
                }
            ],
            "stateMutability": "pure",
        },
        {
            "type": "function",
            "name": "namedTwoMixedStructs",
            "inputs": [],
            "outputs": [
                {
                    "name": "simpleStruct",
                    "type": "tuple",
                    "internalType": "struct Example.SimpleStruct",
                    "components": [
                        {"name": "intVal", "type": "uint256", "internalType": "uint256"},
                        {"name": "strVal", "type": "string", "internalType": "string"},
                    ],
                },
                {
                    "name": "nestedStruct",
                    "type": "tuple",
                    "internalType": "struct Example.NestedStruct",
                    "components": [
                        {"name": "intVal", "type": "uint256", "internalType": "uint256"},
                        {"name": "strVal", "type": "string", "internalType": "string"},
                        {
                            "name": "innerStruct",
                            "type": "tuple",
                            "internalType": "struct Example.InnerStruct",
                            "components": [{"name": "boolVal", "type": "bool", "internalType": "bool"}],
                        },
                    ],
                },
            ],
            "stateMutability": "pure",
        },
        {
            "type": "function",
            "name": "singleNestedStruct",
            "inputs": [
                {
                    "name": "nestedStruct",
                    "type": "tuple",
                    "internalType": "struct Example.NestedStruct",
                    "components": [
                        {"name": "intVal", "type": "uint256", "internalType": "uint256"},
                        {"name": "strVal", "type": "string", "internalType": "string"},
                        {
                            "name": "innerStruct",
                            "type": "tuple",
                            "internalType": "struct Example.InnerStruct",
                            "components": [{"name": "boolVal", "type": "bool", "internalType": "bool"}],
                        },
                    ],
                }
            ],
            "outputs": [
                {
                    "name": "",
                    "type": "tuple",
                    "internalType": "struct Example.NestedStruct",
                    "components": [
                        {"name": "intVal", "type": "uint256", "internalType": "uint256"},
                        {"name": "strVal", "type": "string", "internalType": "string"},
                        {
                            "name": "innerStruct",
                            "type": "tuple",
                            "internalType": "struct Example.InnerStruct",
                            "components": [{"name": "boolVal", "type": "bool", "internalType": "bool"}],
                        },
                    ],
                }
            ],
            "stateMutability": "pure",
        },
        {
            "type": "function",
            "name": "singleSimpleStruct",
            "inputs": [
                {
                    "name": "simpleStruct",
                    "type": "tuple",
                    "internalType": "struct Example.SimpleStruct",
                    "components": [
                        {"name": "intVal", "type": "uint256", "internalType": "uint256"},
                        {"name": "strVal", "type": "string", "internalType": "string"},
                    ],
                }
            ],
            "outputs": [
                {
                    "name": "",
                    "type": "tuple",
                    "internalType": "struct Example.SimpleStruct",
                    "components": [
                        {"name": "intVal", "type": "uint256", "internalType": "uint256"},
                        {"name": "strVal", "type": "string", "internalType": "string"},
                    ],
                }
            ],
            "stateMutability": "pure",
        },
        {
            "type": "function",
            "name": "twoMixedStructs",
            "inputs": [],
            "outputs": [
                {
                    "name": "",
                    "type": "tuple",
                    "internalType": "struct Example.SimpleStruct",
                    "components": [
                        {"name": "intVal", "type": "uint256", "internalType": "uint256"},
                        {"name": "strVal", "type": "string", "internalType": "string"},
                    ],
                },
                {
                    "name": "",
                    "type": "tuple",
                    "internalType": "struct Example.NestedStruct",
                    "components": [
                        {"name": "intVal", "type": "uint256", "internalType": "uint256"},
                        {"name": "strVal", "type": "string", "internalType": "string"},
                        {
                            "name": "innerStruct",
                            "type": "tuple",
                            "internalType": "struct Example.InnerStruct",
                            "components": [{"name": "boolVal", "type": "bool", "internalType": "bool"}],
                        },
                    ],
                },
            ],
            "stateMutability": "pure",
        },
        {
            "type": "function",
            "name": "twoSimpleStructs",
            "inputs": [],
            "outputs": [
                {
                    "name": "",
                    "type": "tuple",
                    "internalType": "struct Example.SimpleStruct",
                    "components": [
                        {"name": "intVal", "type": "uint256", "internalType": "uint256"},
                        {"name": "strVal", "type": "string", "internalType": "string"},
                    ],
                },
                {
                    "name": "",
                    "type": "tuple",
                    "internalType": "struct Example.SimpleStruct",
                    "components": [
                        {"name": "intVal", "type": "uint256", "internalType": "uint256"},
                        {"name": "strVal", "type": "string", "internalType": "string"},
                    ],
                },
            ],
            "stateMutability": "pure",
        },
        {
            "type": "function",
            "name": "vecOfStruct",
            "inputs": [
                {
                    "name": "inVecSimpleStruct",
                    "type": "tuple[]",
                    "internalType": "struct Example.SimpleStruct[]",
                    "components": [
                        {"name": "intVal", "type": "uint256", "internalType": "uint256"},
                        {"name": "strVal", "type": "string", "internalType": "string"},
                    ],
                }
            ],
            "outputs": [
                {
                    "name": "vecSimpleStruct",
                    "type": "tuple[]",
                    "internalType": "struct Example.SimpleStruct[]",
                    "components": [
                        {"name": "intVal", "type": "uint256", "internalType": "uint256"},
                        {"name": "strVal", "type": "string", "internalType": "string"},
                    ],
                }
            ],
            "stateMutability": "pure",
        },
        {
            "type": "event",
            "name": "Flip",
            "inputs": [{"name": "flip", "type": "uint256", "indexed": False, "internalType": "uint256"}],
            "anonymous": False,
        },
        {
            "type": "event",
            "name": "Flop",
            "inputs": [{"name": "flop", "type": "uint256", "indexed": False, "internalType": "uint256"}],
            "anonymous": False,
        },
        {
            "type": "error",
            "name": "WrongChoice",
            "inputs": [
                {"name": "answer", "type": "uint8", "internalType": "enum Example.Letters"},
                {"name": "errorMessage", "type": "string", "internalType": "string"},
            ],
        },
    ],
)


class ExampleContract(Contract):
    """A web3.py Contract class for the Example contract."""

    abi: ABI = example_abi
    # We change `bytecode` as needed for linking, but keep
    # `_raw_bytecode` unchanged as an original copy.
    # pylint: disable=line-too-long
    _raw_bytecode: HexStr | None = HexStr(
        "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"
    )

    def __init__(self, address: ChecksumAddress | None = None) -> None:
        # Initialize parent Contract class
        super().__init__(address=address)
        self.functions = ExampleContractFunctions(example_abi, self.w3, address)  # type: ignore
        self.events = ExampleContractEvents(example_abi, self.w3, address)  # type: ignore
        self.errors = ExampleContractErrors()

    events: ExampleContractEvents

    errors: ExampleContractErrors = ExampleContractErrors()

    functions: ExampleContractFunctions

    class ConstructorArgs(NamedTuple):
        """Arguments to pass the contract's constructor function."""

        name: str

    @classmethod
    def constructor(cls, name: str) -> ContractConstructor:  # type: ignore
        """Creates a transaction with the contract's constructor function.

        Parameters
        ----------

        w3 : Web3
            A web3 instance.
        account : LocalAccount
            The account to use to deploy the contract.

        Returns
        -------
        Self
            A deployed instance of the contract.

        """
        cls.bytecode = cls._raw_bytecode
        if cls.bytecode is not None:

            # bytecode needs to be in hex for web3
            cls.bytecode = HexBytes(cls.bytecode)

        return super().constructor(dataclass_to_tuple(name))

    @classmethod
    def deploy(cls, w3: Web3, account: LocalAccount | ChecksumAddress, constructor_args: ConstructorArgs) -> Self:
        """Deploys an instance of the contract.

        Parameters
        ----------
        w3 : Web3
            A web3 instance.
        account : LocalAccount
            The account to use to deploy the contract.

        Returns
        -------
        Self
            A deployed instance of the contract.
        """
        deployer = cls.factory(w3=w3)
        constructor_fn = deployer.constructor(
            *constructor_args,
        )

        # if an address is supplied, try to use a web3 default account
        if isinstance(account, str):
            tx_hash = constructor_fn.transact({"from": account})
            tx_receipt = w3.eth.wait_for_transaction_receipt(tx_hash)

            deployed_contract = deployer(address=tx_receipt.contractAddress)  # type: ignore
            return deployed_contract

        # otherwise use the account provided.
        deployment_tx = constructor_fn.build_transaction()
        current_nonce = w3.eth.get_transaction_count(account.address, "pending")
        deployment_tx.update({"nonce": current_nonce})

        # Sign the transaction with local account private key
        signed_tx = account.sign_transaction(deployment_tx)

        # Send the signed transaction and wait for receipt
        tx_hash = w3.eth.send_raw_transaction(signed_tx.raw_transaction)
        tx_receipt = w3.eth.wait_for_transaction_receipt(tx_hash)

        deployed_contract = deployer(address=tx_receipt.contractAddress)  # type: ignore
        return deployed_contract

    @classmethod
    def factory(cls, w3: Web3, class_name: str | None = None, **kwargs: Any) -> Type[Self]:
        """Initializes the contract object.

        Parameters
        ----------
        w3 : Web3
            A web3 instance.
        class_name: str | None
            The instance class name.

        Returns
        -------
        Self
            An instance of the contract class.
        """
        contract = super().factory(w3, class_name, **kwargs)
        contract.functions = ExampleContractFunctions(example_abi, w3, None)
        contract.errors = ExampleContractErrors()

        return contract
