#pragma once

#include <nw/rules/Spell.hpp>

namespace nwn1 {

constexpr nw::Spell spell_all_spells = nw::Spell::invalid; // used for spell immunity.

constexpr nw::Spell spell_acid_fog = nw::make_spell(0);
constexpr nw::Spell spell_aid = nw::make_spell(1);
constexpr nw::Spell spell_animate_dead = nw::make_spell(2);
constexpr nw::Spell spell_barkskin = nw::make_spell(3);
constexpr nw::Spell spell_bestow_curse = nw::make_spell(4);
constexpr nw::Spell spell_blade_barrier = nw::make_spell(5);
constexpr nw::Spell spell_bless = nw::make_spell(6);
constexpr nw::Spell spell_bless_weapon = nw::make_spell(537);
constexpr nw::Spell spell_blindness_and_deafness = nw::make_spell(8);
constexpr nw::Spell spell_bulls_strength = nw::make_spell(9);
constexpr nw::Spell spell_burning_hands = nw::make_spell(10);
constexpr nw::Spell spell_call_lightning = nw::make_spell(11);
// constexpr nw::Spell spell_calm_emotions =nw::make_spell( 12);
constexpr nw::Spell spell_cats_grace = nw::make_spell(13);
constexpr nw::Spell spell_chain_lightning = nw::make_spell(14);
constexpr nw::Spell spell_charm_monster = nw::make_spell(15);
constexpr nw::Spell spell_charm_person = nw::make_spell(16);
constexpr nw::Spell spell_charm_person_or_animal = nw::make_spell(17);
constexpr nw::Spell spell_circle_of_death = nw::make_spell(18);
constexpr nw::Spell spell_circle_of_doom = nw::make_spell(19);
constexpr nw::Spell spell_clairaudience_and_clairvoyance = nw::make_spell(20);
constexpr nw::Spell spell_clarity = nw::make_spell(21);
constexpr nw::Spell spell_cloak_of_chaos = nw::make_spell(22);
constexpr nw::Spell spell_cloudkill = nw::make_spell(23);
constexpr nw::Spell spell_color_spray = nw::make_spell(24);
constexpr nw::Spell spell_cone_of_cold = nw::make_spell(25);
constexpr nw::Spell spell_confusion = nw::make_spell(26);
constexpr nw::Spell spell_contagion = nw::make_spell(27);
constexpr nw::Spell spell_control_undead = nw::make_spell(28);
constexpr nw::Spell spell_create_greater_undead = nw::make_spell(29);
constexpr nw::Spell spell_create_undead = nw::make_spell(30);
constexpr nw::Spell spell_cure_critical_wounds = nw::make_spell(31);
constexpr nw::Spell spell_cure_light_wounds = nw::make_spell(32);
constexpr nw::Spell spell_cure_minor_wounds = nw::make_spell(33);
constexpr nw::Spell spell_cure_moderate_wounds = nw::make_spell(34);
constexpr nw::Spell spell_cure_serious_wounds = nw::make_spell(35);
constexpr nw::Spell spell_darkness = nw::make_spell(36);
constexpr nw::Spell spell_daze = nw::make_spell(37);
constexpr nw::Spell spell_death_ward = nw::make_spell(38);
constexpr nw::Spell spell_delayed_blast_fireball = nw::make_spell(39);
constexpr nw::Spell spell_dismissal = nw::make_spell(40);
constexpr nw::Spell spell_dispel_magic = nw::make_spell(41);
constexpr nw::Spell spell_divine_power = nw::make_spell(42);
constexpr nw::Spell spell_dominate_animal = nw::make_spell(43);
constexpr nw::Spell spell_dominate_monster = nw::make_spell(44);
constexpr nw::Spell spell_dominate_person = nw::make_spell(45);
constexpr nw::Spell spell_doom = nw::make_spell(46);
constexpr nw::Spell spell_elemental_shield = nw::make_spell(47);
constexpr nw::Spell spell_elemental_swarm = nw::make_spell(48);
constexpr nw::Spell spell_endurance = nw::make_spell(49);
constexpr nw::Spell spell_endure_elements = nw::make_spell(50);
constexpr nw::Spell spell_energy_drain = nw::make_spell(51);
constexpr nw::Spell spell_enervation = nw::make_spell(52);
constexpr nw::Spell spell_entangle = nw::make_spell(53);
constexpr nw::Spell spell_fear = nw::make_spell(54);
constexpr nw::Spell spell_feeblemind = nw::make_spell(55);
constexpr nw::Spell spell_finger_of_death = nw::make_spell(56);
constexpr nw::Spell spell_fire_storm = nw::make_spell(57);
constexpr nw::Spell spell_fireball = nw::make_spell(58);
constexpr nw::Spell spell_flame_arrow = nw::make_spell(59);
constexpr nw::Spell spell_flame_lash = nw::make_spell(60);
constexpr nw::Spell spell_flame_strike = nw::make_spell(61);
constexpr nw::Spell spell_freedom_of_movement = nw::make_spell(62);
constexpr nw::Spell spell_gate = nw::make_spell(63);
constexpr nw::Spell spell_ghoul_touch = nw::make_spell(64);
constexpr nw::Spell spell_globe_of_invulnerability = nw::make_spell(65);
constexpr nw::Spell spell_grease = nw::make_spell(66);
constexpr nw::Spell spell_greater_dispelling = nw::make_spell(67);
// constexpr nw::Spell spell_greater_magic_weapon              =nw::make_spell( 68);
constexpr nw::Spell spell_greater_planar_binding = nw::make_spell(69);
constexpr nw::Spell spell_greater_restoration = nw::make_spell(70);
// constexpr nw::Spell spell_greater_shadow_conjuration =nw::make_spell( 71);
constexpr nw::Spell spell_greater_spell_breach = nw::make_spell(72);
constexpr nw::Spell spell_greater_spell_mantle = nw::make_spell(73);
constexpr nw::Spell spell_greater_stoneskin = nw::make_spell(74);
constexpr nw::Spell spell_gust_of_wind = nw::make_spell(75);
constexpr nw::Spell spell_hammer_of_the_gods = nw::make_spell(76);
constexpr nw::Spell spell_harm = nw::make_spell(77);
constexpr nw::Spell spell_haste = nw::make_spell(78);
constexpr nw::Spell spell_heal = nw::make_spell(79);
constexpr nw::Spell spell_healing_circle = nw::make_spell(80);
constexpr nw::Spell spell_hold_animal = nw::make_spell(81);
constexpr nw::Spell spell_hold_monster = nw::make_spell(82);
constexpr nw::Spell spell_hold_person = nw::make_spell(83);
constexpr nw::Spell spell_holy_aura = nw::make_spell(84);
constexpr nw::Spell spell_holy_sword = nw::make_spell(538);
constexpr nw::Spell spell_identify = nw::make_spell(86);
constexpr nw::Spell spell_implosion = nw::make_spell(87);
constexpr nw::Spell spell_improved_invisibility = nw::make_spell(88);
constexpr nw::Spell spell_incendiary_cloud = nw::make_spell(89);
constexpr nw::Spell spell_invisibility = nw::make_spell(90);
constexpr nw::Spell spell_invisibility_purge = nw::make_spell(91);
constexpr nw::Spell spell_invisibility_sphere = nw::make_spell(92);
constexpr nw::Spell spell_knock = nw::make_spell(93);
constexpr nw::Spell spell_lesser_dispel = nw::make_spell(94);
constexpr nw::Spell spell_lesser_mind_blank = nw::make_spell(95);
constexpr nw::Spell spell_lesser_planar_binding = nw::make_spell(96);
constexpr nw::Spell spell_lesser_restoration = nw::make_spell(97);
constexpr nw::Spell spell_lesser_spell_breach = nw::make_spell(98);
constexpr nw::Spell spell_lesser_spell_mantle = nw::make_spell(99);
constexpr nw::Spell spell_light = nw::make_spell(100);
constexpr nw::Spell spell_lightning_bolt = nw::make_spell(101);
constexpr nw::Spell spell_mage_armor = nw::make_spell(102);
constexpr nw::Spell spell_magic_circle_against_chaos = nw::make_spell(103);
constexpr nw::Spell spell_magic_circle_against_evil = nw::make_spell(104);
constexpr nw::Spell spell_magic_circle_against_good = nw::make_spell(105);
constexpr nw::Spell spell_magic_circle_against_law = nw::make_spell(106);
constexpr nw::Spell spell_magic_missile = nw::make_spell(107);
constexpr nw::Spell spell_magic_vestment = nw::make_spell(546);
// constexpr nw::Spell spell_magic_weapon                      =nw::make_spell( 109);
constexpr nw::Spell spell_mass_blindness_and_deafness = nw::make_spell(110);
constexpr nw::Spell spell_mass_charm = nw::make_spell(111);
// constexpr nw::Spell spell_mass_domination =nw::make_spell( 112);
constexpr nw::Spell spell_mass_haste = nw::make_spell(113);
constexpr nw::Spell spell_mass_heal = nw::make_spell(114);
constexpr nw::Spell spell_melfs_acid_arrow = nw::make_spell(115);
constexpr nw::Spell spell_meteor_swarm = nw::make_spell(116);
constexpr nw::Spell spell_mind_blank = nw::make_spell(117);
constexpr nw::Spell spell_mind_fog = nw::make_spell(118);
constexpr nw::Spell spell_minor_globe_of_invulnerability = nw::make_spell(119);
constexpr nw::Spell spell_ghostly_visage = nw::make_spell(120);
constexpr nw::Spell spell_ethereal_visage = nw::make_spell(121);
constexpr nw::Spell spell_mordenkainens_disjunction = nw::make_spell(122);
constexpr nw::Spell spell_mordenkainens_sword = nw::make_spell(123);
constexpr nw::Spell spell_natures_balance = nw::make_spell(124);
constexpr nw::Spell spell_negative_energy_protection = nw::make_spell(125);
constexpr nw::Spell spell_neutralize_poison = nw::make_spell(126);
constexpr nw::Spell spell_phantasmal_killer = nw::make_spell(127);
constexpr nw::Spell spell_planar_binding = nw::make_spell(128);
constexpr nw::Spell spell_poison = nw::make_spell(129);
constexpr nw::Spell spell_polymorph_self = nw::make_spell(130);
constexpr nw::Spell spell_power_word_kill = nw::make_spell(131);
constexpr nw::Spell spell_power_word_stun = nw::make_spell(132);
constexpr nw::Spell spell_prayer = nw::make_spell(133);
constexpr nw::Spell spell_premonition = nw::make_spell(134);
constexpr nw::Spell spell_prismatic_spray = nw::make_spell(135);
constexpr nw::Spell spell_protection__from_chaos = nw::make_spell(136);
constexpr nw::Spell spell_protection_from_elements = nw::make_spell(137);
constexpr nw::Spell spell_protection_from_evil = nw::make_spell(138);
constexpr nw::Spell spell_protection_from_good = nw::make_spell(139);
constexpr nw::Spell spell_protection_from_law = nw::make_spell(140);
constexpr nw::Spell spell_protection_from_spells = nw::make_spell(141);
constexpr nw::Spell spell_raise_dead = nw::make_spell(142);
constexpr nw::Spell spell_ray_of_enfeeblement = nw::make_spell(143);
constexpr nw::Spell spell_ray_of_frost = nw::make_spell(144);
constexpr nw::Spell spell_remove_blindness_and_deafness = nw::make_spell(145);
constexpr nw::Spell spell_remove_curse = nw::make_spell(146);
constexpr nw::Spell spell_remove_disease = nw::make_spell(147);
constexpr nw::Spell spell_remove_fear = nw::make_spell(148);
constexpr nw::Spell spell_remove_paralysis = nw::make_spell(149);
constexpr nw::Spell spell_resist_elements = nw::make_spell(150);
constexpr nw::Spell spell_resistance = nw::make_spell(151);
constexpr nw::Spell spell_restoration = nw::make_spell(152);
constexpr nw::Spell spell_resurrection = nw::make_spell(153);
constexpr nw::Spell spell_sanctuary = nw::make_spell(154);
constexpr nw::Spell spell_scare = nw::make_spell(155);
constexpr nw::Spell spell_searing_light = nw::make_spell(156);
constexpr nw::Spell spell_see_invisibility = nw::make_spell(157);
// constexpr nw::Spell spell_shades =nw::make_spell( 158);
// constexpr nw::Spell spell_shadow_conjuration =nw::make_spell( 159);
constexpr nw::Spell spell_shadow_shield = nw::make_spell(160);
constexpr nw::Spell spell_shapechange = nw::make_spell(161);
constexpr nw::Spell spell_shield_of_law = nw::make_spell(162);
constexpr nw::Spell spell_silence = nw::make_spell(163);
constexpr nw::Spell spell_slay_living = nw::make_spell(164);
constexpr nw::Spell spell_sleep = nw::make_spell(165);
constexpr nw::Spell spell_slow = nw::make_spell(166);
constexpr nw::Spell spell_sound_burst = nw::make_spell(167);
constexpr nw::Spell spell_spell_resistance = nw::make_spell(168);
constexpr nw::Spell spell_spell_mantle = nw::make_spell(169);
constexpr nw::Spell spell_sphere_of_chaos = nw::make_spell(170);
constexpr nw::Spell spell_stinking_cloud = nw::make_spell(171);
constexpr nw::Spell spell_stoneskin = nw::make_spell(172);
constexpr nw::Spell spell_storm_of_vengeance = nw::make_spell(173);
constexpr nw::Spell spell_summon_creature_i = nw::make_spell(174);
constexpr nw::Spell spell_summon_creature_ii = nw::make_spell(175);
constexpr nw::Spell spell_summon_creature_iii = nw::make_spell(176);
constexpr nw::Spell spell_summon_creature_iv = nw::make_spell(177);
constexpr nw::Spell spell_summon_creature_ix = nw::make_spell(178);
constexpr nw::Spell spell_summon_creature_v = nw::make_spell(179);
constexpr nw::Spell spell_summon_creature_vi = nw::make_spell(180);
constexpr nw::Spell spell_summon_creature_vii = nw::make_spell(181);
constexpr nw::Spell spell_summon_creature_viii = nw::make_spell(182);
constexpr nw::Spell spell_sunbeam = nw::make_spell(183);
constexpr nw::Spell spell_tensers_transformation = nw::make_spell(184);
constexpr nw::Spell spell_time_stop = nw::make_spell(185);
constexpr nw::Spell spell_true_seeing = nw::make_spell(186);
constexpr nw::Spell spell_unholy_aura = nw::make_spell(187);
constexpr nw::Spell spell_vampiric_touch = nw::make_spell(188);
constexpr nw::Spell spell_virtue = nw::make_spell(189);
constexpr nw::Spell spell_wail_of_the_banshee = nw::make_spell(190);
constexpr nw::Spell spell_wall_of_fire = nw::make_spell(191);
constexpr nw::Spell spell_web = nw::make_spell(192);
constexpr nw::Spell spell_weird = nw::make_spell(193);
constexpr nw::Spell spell_word_of_faith = nw::make_spell(194);
constexpr nw::Spell spellability_aura_blinding = nw::make_spell(195);
constexpr nw::Spell spellability_aura_cold = nw::make_spell(196);
constexpr nw::Spell spellability_aura_electricity = nw::make_spell(197);
constexpr nw::Spell spellability_aura_fear = nw::make_spell(198);
constexpr nw::Spell spellability_aura_fire = nw::make_spell(199);
constexpr nw::Spell spellability_aura_menace = nw::make_spell(200);
constexpr nw::Spell spellability_aura_protection = nw::make_spell(201);
constexpr nw::Spell spellability_aura_stun = nw::make_spell(202);
constexpr nw::Spell spellability_aura_unearthly_visage = nw::make_spell(203);
constexpr nw::Spell spellability_aura_unnatural = nw::make_spell(204);
constexpr nw::Spell spellability_bolt_ability_drain_charisma = nw::make_spell(205);
constexpr nw::Spell spellability_bolt_ability_drain_constitution = nw::make_spell(206);
constexpr nw::Spell spellability_bolt_ability_drain_dexterity = nw::make_spell(207);
constexpr nw::Spell spellability_bolt_ability_drain_intelligence = nw::make_spell(208);
constexpr nw::Spell spellability_bolt_ability_drain_strength = nw::make_spell(209);
constexpr nw::Spell spellability_bolt_ability_drain_wisdom = nw::make_spell(210);
constexpr nw::Spell spellability_bolt_acid = nw::make_spell(211);
constexpr nw::Spell spellability_bolt_charm = nw::make_spell(212);
constexpr nw::Spell spellability_bolt_cold = nw::make_spell(213);
constexpr nw::Spell spellability_bolt_confuse = nw::make_spell(214);
constexpr nw::Spell spellability_bolt_daze = nw::make_spell(215);
constexpr nw::Spell spellability_bolt_death = nw::make_spell(216);
constexpr nw::Spell spellability_bolt_disease = nw::make_spell(217);
constexpr nw::Spell spellability_bolt_dominate = nw::make_spell(218);
constexpr nw::Spell spellability_bolt_fire = nw::make_spell(219);
constexpr nw::Spell spellability_bolt_knockdown = nw::make_spell(220);
constexpr nw::Spell spellability_bolt_level_drain = nw::make_spell(221);
constexpr nw::Spell spellability_bolt_lightning = nw::make_spell(222);
constexpr nw::Spell spellability_bolt_paralyze = nw::make_spell(223);
constexpr nw::Spell spellability_bolt_poison = nw::make_spell(224);
constexpr nw::Spell spellability_bolt_shards = nw::make_spell(225);
constexpr nw::Spell spellability_bolt_slow = nw::make_spell(226);
constexpr nw::Spell spellability_bolt_stun = nw::make_spell(227);
constexpr nw::Spell spellability_bolt_web = nw::make_spell(228);
constexpr nw::Spell spellability_cone_acid = nw::make_spell(229);
constexpr nw::Spell spellability_cone_cold = nw::make_spell(230);
constexpr nw::Spell spellability_cone_disease = nw::make_spell(231);
constexpr nw::Spell spellability_cone_fire = nw::make_spell(232);
constexpr nw::Spell spellability_cone_lightning = nw::make_spell(233);
constexpr nw::Spell spellability_cone_poison = nw::make_spell(234);
constexpr nw::Spell spellability_cone_sonic = nw::make_spell(235);
constexpr nw::Spell spellability_dragon_breath_acid = nw::make_spell(236);
constexpr nw::Spell spellability_dragon_breath_cold = nw::make_spell(237);
constexpr nw::Spell spellability_dragon_breath_fear = nw::make_spell(238);
constexpr nw::Spell spellability_dragon_breath_fire = nw::make_spell(239);
constexpr nw::Spell spellability_dragon_breath_gas = nw::make_spell(240);
constexpr nw::Spell spellability_dragon_breath_lightning = nw::make_spell(241);
constexpr nw::Spell spellability_dragon_breath_paralyze = nw::make_spell(242);
constexpr nw::Spell spellability_dragon_breath_sleep = nw::make_spell(243);
constexpr nw::Spell spellability_dragon_breath_slow = nw::make_spell(244);
constexpr nw::Spell spellability_dragon_breath_weaken = nw::make_spell(245);
constexpr nw::Spell spellability_dragon_wing_buffet = nw::make_spell(246);
constexpr nw::Spell spellability_ferocity_1 = nw::make_spell(247);
constexpr nw::Spell spellability_ferocity_2 = nw::make_spell(248);
constexpr nw::Spell spellability_ferocity_3 = nw::make_spell(249);
constexpr nw::Spell spellability_gaze_charm = nw::make_spell(250);
constexpr nw::Spell spellability_gaze_confusion = nw::make_spell(251);
constexpr nw::Spell spellability_gaze_daze = nw::make_spell(252);
constexpr nw::Spell spellability_gaze_death = nw::make_spell(253);
constexpr nw::Spell spellability_gaze_destroy_chaos = nw::make_spell(254);
constexpr nw::Spell spellability_gaze_destroy_evil = nw::make_spell(255);
constexpr nw::Spell spellability_gaze_destroy_good = nw::make_spell(256);
constexpr nw::Spell spellability_gaze_destroy_law = nw::make_spell(257);
constexpr nw::Spell spellability_gaze_dominate = nw::make_spell(258);
constexpr nw::Spell spellability_gaze_doom = nw::make_spell(259);
constexpr nw::Spell spellability_gaze_fear = nw::make_spell(260);
constexpr nw::Spell spellability_gaze_paralysis = nw::make_spell(261);
constexpr nw::Spell spellability_gaze_stunned = nw::make_spell(262);
constexpr nw::Spell spellability_golem_breath_gas = nw::make_spell(263);
constexpr nw::Spell spellability_hell_hound_firebreath = nw::make_spell(264);
constexpr nw::Spell spellability_howl_confuse = nw::make_spell(265);
constexpr nw::Spell spellability_howl_daze = nw::make_spell(266);
constexpr nw::Spell spellability_howl_death = nw::make_spell(267);
constexpr nw::Spell spellability_howl_doom = nw::make_spell(268);
constexpr nw::Spell spellability_howl_fear = nw::make_spell(269);
constexpr nw::Spell spellability_howl_paralysis = nw::make_spell(270);
constexpr nw::Spell spellability_howl_sonic = nw::make_spell(271);
constexpr nw::Spell spellability_howl_stun = nw::make_spell(272);
constexpr nw::Spell spellability_intensity_1 = nw::make_spell(273);
constexpr nw::Spell spellability_intensity_2 = nw::make_spell(274);
constexpr nw::Spell spellability_intensity_3 = nw::make_spell(275);
constexpr nw::Spell spellability_krenshar_scare = nw::make_spell(276);
constexpr nw::Spell spellability_lesser_body_adjustment = nw::make_spell(277);
constexpr nw::Spell spellability_mephit_salt_breath = nw::make_spell(278);
constexpr nw::Spell spellability_mephit_steam_breath = nw::make_spell(279);
constexpr nw::Spell spellability_mummy_bolster_undead = nw::make_spell(280);
constexpr nw::Spell spellability_pulse_drown = nw::make_spell(281);
constexpr nw::Spell spellability_pulse_spores = nw::make_spell(282);
constexpr nw::Spell spellability_pulse_whirlwind = nw::make_spell(283);
constexpr nw::Spell spellability_pulse_fire = nw::make_spell(284);
constexpr nw::Spell spellability_pulse_lightning = nw::make_spell(285);
constexpr nw::Spell spellability_pulse_cold = nw::make_spell(286);
constexpr nw::Spell spellability_pulse_negative = nw::make_spell(287);
constexpr nw::Spell spellability_pulse_holy = nw::make_spell(288);
constexpr nw::Spell spellability_pulse_death = nw::make_spell(289);
constexpr nw::Spell spellability_pulse_level_drain = nw::make_spell(290);
constexpr nw::Spell spellability_pulse_ability_drain_intelligence = nw::make_spell(291);
constexpr nw::Spell spellability_pulse_ability_drain_charisma = nw::make_spell(292);
constexpr nw::Spell spellability_pulse_ability_drain_constitution = nw::make_spell(293);
constexpr nw::Spell spellability_pulse_ability_drain_dexterity = nw::make_spell(294);
constexpr nw::Spell spellability_pulse_ability_drain_strength = nw::make_spell(295);
constexpr nw::Spell spellability_pulse_ability_drain_wisdom = nw::make_spell(296);
constexpr nw::Spell spellability_pulse_poison = nw::make_spell(297);
constexpr nw::Spell spellability_pulse_disease = nw::make_spell(298);
constexpr nw::Spell spellability_rage_3 = nw::make_spell(299);
constexpr nw::Spell spellability_rage_4 = nw::make_spell(300);
constexpr nw::Spell spellability_rage_5 = nw::make_spell(301);
constexpr nw::Spell spellability_smoke_claw = nw::make_spell(302);
constexpr nw::Spell spellability_summon_slaad = nw::make_spell(303);
constexpr nw::Spell spellability_summon_tanarri = nw::make_spell(304);
constexpr nw::Spell spellability_trumpet_blast = nw::make_spell(305);
constexpr nw::Spell spellability_tyrant_fog_mist = nw::make_spell(306);
constexpr nw::Spell spellability_barbarian_rage = nw::make_spell(307);
constexpr nw::Spell spellability_turn_undead = nw::make_spell(308);
constexpr nw::Spell spellability_wholeness_of_body = nw::make_spell(309);
constexpr nw::Spell spellability_quivering_palm = nw::make_spell(310);
constexpr nw::Spell spellability_empty_body = nw::make_spell(311);
constexpr nw::Spell spellability_detect_evil = nw::make_spell(312);
constexpr nw::Spell spellability_lay_on_hands = nw::make_spell(313);
constexpr nw::Spell spellability_aura_of_courage = nw::make_spell(314);
constexpr nw::Spell spellability_smite_evil = nw::make_spell(315);
constexpr nw::Spell spellability_remove_disease = nw::make_spell(316);
constexpr nw::Spell spellability_summon_animal_companion = nw::make_spell(317);
constexpr nw::Spell spellability_summon_familiar = nw::make_spell(318);
constexpr nw::Spell spellability_elemental_shape = nw::make_spell(319);
constexpr nw::Spell spellability_wild_shape = nw::make_spell(320);
// constexpr nw::Spell spell_protection_from_alignment =nw::make_spell( 321);
// constexpr nw::Spell spell_magic_circle_against_alignment =nw::make_spell( 322);
// constexpr nw::Spell spell_aura_versus_alignment =nw::make_spell( 323);
constexpr nw::Spell spell_shades_summon_shadow = nw::make_spell(324);
// constexpr nw::Spell spell_protection_from_elements_cold =nw::make_spell( 325);
// constexpr nw::Spell spell_protection_from_elements_fire =nw::make_spell( 326);
// constexpr nw::Spell spell_protection_from_elements_acid =nw::make_spell( 327);
// constexpr nw::Spell spell_protection_from_elements_sonic =nw::make_spell( 328);
// constexpr nw::Spell spell_protection_from_elements_electricity =nw::make_spell( 329);
// constexpr nw::Spell spell_endure_elements_cold =nw::make_spell( 330);
// constexpr nw::Spell spell_endure_elements_fire =nw::make_spell( 331);
// constexpr nw::Spell spell_endure_elements_acid =nw::make_spell( 332);
// constexpr nw::Spell spell_endure_elements_sonic =nw::make_spell( 333);
// constexpr nw::Spell spell_endure_elements_electricity =nw::make_spell( 334);
// constexpr nw::Spell spell_resist_elements_cold =nw::make_spell( 335);
// constexpr nw::Spell spell_resist_elements_fire =nw::make_spell( 336);
// constexpr nw::Spell spell_resist_elements_acid =nw::make_spell( 337);
// constexpr nw::Spell spell_resist_elements_sonic =nw::make_spell( 338);
// constexpr nw::Spell spell_resist_elements_electricity =nw::make_spell( 339);
constexpr nw::Spell spell_shades_cone_of_cold = nw::make_spell(340);
constexpr nw::Spell spell_shades_fireball = nw::make_spell(341);
constexpr nw::Spell spell_shades_stoneskin = nw::make_spell(342);
constexpr nw::Spell spell_shades_wall_of_fire = nw::make_spell(343);
constexpr nw::Spell spell_shadow_conjuration_summon_shadow = nw::make_spell(344);
constexpr nw::Spell spell_shadow_conjuration_darkness = nw::make_spell(345);
constexpr nw::Spell spell_shadow_conjuration_inivsibility = nw::make_spell(346);
constexpr nw::Spell spell_shadow_conjuration_mage_armor = nw::make_spell(347);
constexpr nw::Spell spell_shadow_conjuration_magic_missile = nw::make_spell(348);
constexpr nw::Spell spell_greater_shadow_conjuration_summon_shadow = nw::make_spell(349);
constexpr nw::Spell spell_greater_shadow_conjuration_acid_arrow = nw::make_spell(350);
constexpr nw::Spell spell_greater_shadow_conjuration_mirror_image = nw::make_spell(351);
constexpr nw::Spell spell_greater_shadow_conjuration_web = nw::make_spell(352);
constexpr nw::Spell spell_greater_shadow_conjuration_minor_globe = nw::make_spell(353);
constexpr nw::Spell spell_eagle_spledor = nw::make_spell(354);
constexpr nw::Spell spell_owls_wisdom = nw::make_spell(355);
constexpr nw::Spell spell_foxs_cunning = nw::make_spell(356);
constexpr nw::Spell spell_greater_eagle_splendor = nw::make_spell(357);
constexpr nw::Spell spell_greater_owls_wisdom = nw::make_spell(358);
constexpr nw::Spell spell_greater_foxs_cunning = nw::make_spell(359);
constexpr nw::Spell spell_greater_bulls_strength = nw::make_spell(360);
constexpr nw::Spell spell_greater_cats_grace = nw::make_spell(361);
constexpr nw::Spell spell_greater_endurance = nw::make_spell(362);
constexpr nw::Spell spell_awaken = nw::make_spell(363);
constexpr nw::Spell spell_creeping_doom = nw::make_spell(364);
constexpr nw::Spell spell_darkvision = nw::make_spell(365);
constexpr nw::Spell spell_destruction = nw::make_spell(366);
constexpr nw::Spell spell_horrid_wilting = nw::make_spell(367);
constexpr nw::Spell spell_ice_storm = nw::make_spell(368);
constexpr nw::Spell spell_energy_buffer = nw::make_spell(369);
constexpr nw::Spell spell_negative_energy_burst = nw::make_spell(370);
constexpr nw::Spell spell_negative_energy_ray = nw::make_spell(371);
constexpr nw::Spell spell_aura_of_vitality = nw::make_spell(372);
constexpr nw::Spell spell_war_cry = nw::make_spell(373);
constexpr nw::Spell spell_regenerate = nw::make_spell(374);
constexpr nw::Spell spell_evards_black_tentacles = nw::make_spell(375);
constexpr nw::Spell spell_legend_lore = nw::make_spell(376);
constexpr nw::Spell spell_find_traps = nw::make_spell(377);
constexpr nw::Spell spellability_summon_mephit = nw::make_spell(378);

constexpr nw::Spell spellability_summon_celestial = nw::make_spell(379);
constexpr nw::Spell spellability_battle_mastery = nw::make_spell(380);
constexpr nw::Spell spellability_divine_strength = nw::make_spell(381);
constexpr nw::Spell spellability_divine_protection = nw::make_spell(382);
constexpr nw::Spell spellability_negative_plane_avatar = nw::make_spell(383);
constexpr nw::Spell spellability_divine_trickery = nw::make_spell(384);
constexpr nw::Spell spellability_rogues_cunning = nw::make_spell(385);
constexpr nw::Spell spellability_activate_item = nw::make_spell(386);
constexpr nw::Spell spellability_dragon_fear = nw::make_spell(412);

constexpr nw::Spell spell_divine_favor = nw::make_spell(414);
constexpr nw::Spell spell_true_strike = nw::make_spell(415);
constexpr nw::Spell spell_flare = nw::make_spell(416);
constexpr nw::Spell spell_shield = nw::make_spell(417);
constexpr nw::Spell spell_entropic_shield = nw::make_spell(418);
constexpr nw::Spell spell_continual_flame = nw::make_spell(419);
constexpr nw::Spell spell_one_with_the_land = nw::make_spell(420);
constexpr nw::Spell spell_camoflage = nw::make_spell(421);
constexpr nw::Spell spell_blood_frenzy = nw::make_spell(422);
constexpr nw::Spell spell_bombardment = nw::make_spell(423);
constexpr nw::Spell spell_acid_splash = nw::make_spell(424);
constexpr nw::Spell spell_quillfire = nw::make_spell(425);
constexpr nw::Spell spell_earthquake = nw::make_spell(426);
constexpr nw::Spell spell_sunburst = nw::make_spell(427);
constexpr nw::Spell spell_activate_item_self2 = nw::make_spell(428);
constexpr nw::Spell spell_auraofglory = nw::make_spell(429);
constexpr nw::Spell spell_banishment = nw::make_spell(430);
constexpr nw::Spell spell_inflict_minor_wounds = nw::make_spell(431);
constexpr nw::Spell spell_inflict_light_wounds = nw::make_spell(432);
constexpr nw::Spell spell_inflict_moderate_wounds = nw::make_spell(433);
constexpr nw::Spell spell_inflict_serious_wounds = nw::make_spell(434);
constexpr nw::Spell spell_inflict_critical_wounds = nw::make_spell(435);
constexpr nw::Spell spell_balagarnsironhorn = nw::make_spell(436);
constexpr nw::Spell spell_drown = nw::make_spell(437);
constexpr nw::Spell spell_owls_insight = nw::make_spell(438);
constexpr nw::Spell spell_electric_jolt = nw::make_spell(439);
constexpr nw::Spell spell_firebrand = nw::make_spell(440);
constexpr nw::Spell spell_wounding_whispers = nw::make_spell(441);
constexpr nw::Spell spell_amplify = nw::make_spell(442);
constexpr nw::Spell spell_etherealness = nw::make_spell(443);
constexpr nw::Spell spell_undeaths_eternal_foe = nw::make_spell(444);
constexpr nw::Spell spell_dirge = nw::make_spell(445);
constexpr nw::Spell spell_inferno = nw::make_spell(446);
constexpr nw::Spell spell_isaacs_lesser_missile_storm = nw::make_spell(447);
constexpr nw::Spell spell_isaacs_greater_missile_storm = nw::make_spell(448);
constexpr nw::Spell spell_bane = nw::make_spell(449);
constexpr nw::Spell spell_shield_of_faith = nw::make_spell(450);
constexpr nw::Spell spell_planar_ally = nw::make_spell(451);
constexpr nw::Spell spell_magic_fang = nw::make_spell(452);
constexpr nw::Spell spell_greater_magic_fang = nw::make_spell(453);
constexpr nw::Spell spell_spike_growth = nw::make_spell(454);
constexpr nw::Spell spell_mass_camoflage = nw::make_spell(455);
constexpr nw::Spell spell_expeditious_retreat = nw::make_spell(456);
constexpr nw::Spell spell_tashas_hideous_laughter = nw::make_spell(457);
constexpr nw::Spell spell_displacement = nw::make_spell(458);
constexpr nw::Spell spell_bigbys_interposing_hand = nw::make_spell(459);
constexpr nw::Spell spell_bigbys_forceful_hand = nw::make_spell(460);
constexpr nw::Spell spell_bigbys_grasping_hand = nw::make_spell(461);
constexpr nw::Spell spell_bigbys_clenched_fist = nw::make_spell(462);
constexpr nw::Spell spell_bigbys_crushing_hand = nw::make_spell(463);
constexpr nw::Spell spell_grenade_fire = nw::make_spell(464);
constexpr nw::Spell spell_grenade_tangle = nw::make_spell(465);
constexpr nw::Spell spell_grenade_holy = nw::make_spell(466);
constexpr nw::Spell spell_grenade_choking = nw::make_spell(467);
constexpr nw::Spell spell_grenade_thunderstone = nw::make_spell(468);
constexpr nw::Spell spell_grenade_acid = nw::make_spell(469);
constexpr nw::Spell spell_grenade_chicken = nw::make_spell(470);
constexpr nw::Spell spell_grenade_caltrops = nw::make_spell(471);
constexpr nw::Spell spell_activate_item_portal = nw::make_spell(472);
constexpr nw::Spell spell_divine_might = nw::make_spell(473);
constexpr nw::Spell spell_divine_shield = nw::make_spell(474);
constexpr nw::Spell spell_shadow_daze = nw::make_spell(475);
constexpr nw::Spell spell_summon_shadow = nw::make_spell(476);
constexpr nw::Spell spell_shadow_evade = nw::make_spell(477);
constexpr nw::Spell spell_tymoras_smile = nw::make_spell(478);
constexpr nw::Spell spell_craft_harper_item = nw::make_spell(479);
constexpr nw::Spell spell_flesh_to_stone = nw::make_spell(485);
constexpr nw::Spell spell_stone_to_flesh = nw::make_spell(486);
constexpr nw::Spell spell_trap_arrow = nw::make_spell(487);
constexpr nw::Spell spell_trap_bolt = nw::make_spell(488);
constexpr nw::Spell spell_trap_dart = nw::make_spell(493);
constexpr nw::Spell spell_trap_shuriken = nw::make_spell(494);

constexpr nw::Spell spellability_breath_petrify = nw::make_spell(495);
constexpr nw::Spell spellability_touch_petrify = nw::make_spell(496);
constexpr nw::Spell spellability_gaze_petrify = nw::make_spell(497);
constexpr nw::Spell spellability_manticore_spikes = nw::make_spell(498);

constexpr nw::Spell spell_rod_of_wonder = nw::make_spell(499);
constexpr nw::Spell spell_deck_of_many_things = nw::make_spell(500);
constexpr nw::Spell spell_elemental_summoning_item = nw::make_spell(502);
constexpr nw::Spell spell_deck_avatar = nw::make_spell(503);
constexpr nw::Spell spell_deck_gemspray = nw::make_spell(504);
constexpr nw::Spell spell_deck_butterflyspray = nw::make_spell(505);

constexpr nw::Spell spell_healingkit = nw::make_spell(506);
constexpr nw::Spell spell_powerstone = nw::make_spell(507);
constexpr nw::Spell spell_spellstaff = nw::make_spell(508);
constexpr nw::Spell spell_charger = nw::make_spell(500);
constexpr nw::Spell spell_decharger = nw::make_spell(510);

constexpr nw::Spell spell_kobold_jump = nw::make_spell(511);
constexpr nw::Spell spell_crumble = nw::make_spell(512);
constexpr nw::Spell spell_infestation_of_maggots = nw::make_spell(513);
constexpr nw::Spell spell_healing_sting = nw::make_spell(514);
constexpr nw::Spell spell_great_thunderclap = nw::make_spell(515);
constexpr nw::Spell spell_ball_lightning = nw::make_spell(516);
constexpr nw::Spell spell_battletide = nw::make_spell(517);
constexpr nw::Spell spell_combust = nw::make_spell(518);
constexpr nw::Spell spell_death_armor = nw::make_spell(519);
constexpr nw::Spell spell_gedlees_electric_loop = nw::make_spell(520);
constexpr nw::Spell spell_horizikauls_boom = nw::make_spell(521);
constexpr nw::Spell spell_ironguts = nw::make_spell(522);
constexpr nw::Spell spell_mestils_acid_breath = nw::make_spell(523);
constexpr nw::Spell spell_mestils_acid_sheath = nw::make_spell(524);
constexpr nw::Spell spell_monstrous_regeneration = nw::make_spell(525);
constexpr nw::Spell spell_scintillating_sphere = nw::make_spell(526);
constexpr nw::Spell spell_stone_bones = nw::make_spell(527);
constexpr nw::Spell spell_undeath_to_death = nw::make_spell(528);
constexpr nw::Spell spell_vine_mine = nw::make_spell(529);
constexpr nw::Spell spell_vine_mine_entangle = nw::make_spell(530);
constexpr nw::Spell spell_vine_mine_hamper_movement = nw::make_spell(531);
constexpr nw::Spell spell_vine_mine_camouflage = nw::make_spell(532);
constexpr nw::Spell spell_black_blade_of_disaster = nw::make_spell(533);
constexpr nw::Spell spell_shelgarns_persistent_blade = nw::make_spell(534);
constexpr nw::Spell spell_blade_thirst = nw::make_spell(535);
constexpr nw::Spell spell_deafening_clang = nw::make_spell(536);
constexpr nw::Spell spell_cloud_of_bewilderment = nw::make_spell(569);

constexpr nw::Spell spell_keen_edge = nw::make_spell(539);
constexpr nw::Spell spell_blackstaff = nw::make_spell(541);
constexpr nw::Spell spell_flame_weapon = nw::make_spell(542);
constexpr nw::Spell spell_ice_dagger = nw::make_spell(543);
constexpr nw::Spell spell_magic_weapon = nw::make_spell(544);
constexpr nw::Spell spell_greater_magic_weapon = nw::make_spell(545);

constexpr nw::Spell spell_stonehold = nw::make_spell(547);
constexpr nw::Spell spell_darkfire = nw::make_spell(548);
constexpr nw::Spell spell_glyph_of_warding = nw::make_spell(549);

constexpr nw::Spell spellability_mindblast = nw::make_spell(551);
constexpr nw::Spell spellability_charmmonster = nw::make_spell(552);

constexpr nw::Spell spell_ioun_stone_dusty_rose = nw::make_spell(554);
constexpr nw::Spell spell_ioun_stone_pale_blue = nw::make_spell(555);
constexpr nw::Spell spell_ioun_stone_scarlet_blue = nw::make_spell(556);
constexpr nw::Spell spell_ioun_stone_blue = nw::make_spell(557);
constexpr nw::Spell spell_ioun_stone_deep_red = nw::make_spell(558);
constexpr nw::Spell spell_ioun_stone_pink = nw::make_spell(559);
constexpr nw::Spell spell_ioun_stone_pink_green = nw::make_spell(560);

constexpr nw::Spell spellability_whirlwind = nw::make_spell(561);
constexpr nw::Spell spellability_command_the_horde = nw::make_spell(571);

constexpr nw::Spell spellability_aa_imbue_arrow = nw::make_spell(600);
constexpr nw::Spell spellability_aa_seeker_arrow_1 = nw::make_spell(601);
constexpr nw::Spell spellability_aa_seeker_arrow_2 = nw::make_spell(602);
constexpr nw::Spell spellability_aa_hail_of_arrows = nw::make_spell(603);
constexpr nw::Spell spellability_aa_arrow_of_death = nw::make_spell(604);

constexpr nw::Spell spellability_as_ghostly_visage = nw::make_spell(605);
constexpr nw::Spell spellability_as_darkness = nw::make_spell(606);
constexpr nw::Spell spellability_as_invisibility = nw::make_spell(607);
constexpr nw::Spell spellability_as_improved_invisiblity = nw::make_spell(608);

constexpr nw::Spell spellability_bg_createdead = nw::make_spell(609);
constexpr nw::Spell spellability_bg_fiendish_servant = nw::make_spell(610);
constexpr nw::Spell spellability_bg_inflict_serious_wounds = nw::make_spell(611);
constexpr nw::Spell spellability_bg_inflict_critical_wounds = nw::make_spell(612);
constexpr nw::Spell spellability_bg_contagion = nw::make_spell(613);
constexpr nw::Spell spellability_bg_bulls_strength = nw::make_spell(614);

constexpr nw::Spell spell_flying_debris = nw::make_spell(620);

constexpr nw::Spell spellability_dc_divine_wrath = nw::make_spell(622);
constexpr nw::Spell spellability_pm_animate_dead = nw::make_spell(623);
constexpr nw::Spell spellability_pm_summon_undead = nw::make_spell(624);
constexpr nw::Spell spellability_pm_undead_graft_1 = nw::make_spell(625);
constexpr nw::Spell spellability_pm_undead_graft_2 = nw::make_spell(626);
constexpr nw::Spell spellability_pm_summon_greater_undead = nw::make_spell(627);
constexpr nw::Spell spellability_pm_deathless_master_touch = nw::make_spell(628);
constexpr nw::Spell spell_epic_hellball = nw::make_spell(636);
constexpr nw::Spell spell_epic_mummy_dust = nw::make_spell(637);
constexpr nw::Spell spell_epic_dragon_knight = nw::make_spell(638);
constexpr nw::Spell spell_epic_mage_armor = nw::make_spell(639);
constexpr nw::Spell spell_epic_ruin = nw::make_spell(640);
constexpr nw::Spell spellability_dw_defensive_stance = nw::make_spell(641);
constexpr nw::Spell spellability_epic_mighty_rage = nw::make_spell(642);
constexpr nw::Spell spellability_epic_curse_song = nw::make_spell(644);
constexpr nw::Spell spellability_epic_improved_whirlwind = nw::make_spell(645);
constexpr nw::Spell spellability_epic_shape_dragonkin = nw::make_spell(646);
constexpr nw::Spell spellability_epic_shape_dragon = nw::make_spell(647);
constexpr nw::Spell spell_craft_dye_clothcolor_1 = nw::make_spell(648);
constexpr nw::Spell spell_craft_dye_clothcolor_2 = nw::make_spell(649);
constexpr nw::Spell spell_craft_dye_leathercolor_1 = nw::make_spell(650);
constexpr nw::Spell spell_craft_dye_leathercolor_2 = nw::make_spell(651);
constexpr nw::Spell spell_craft_dye_metalcolor_1 = nw::make_spell(652);
constexpr nw::Spell spell_craft_dye_metalcolor_2 = nw::make_spell(653);
constexpr nw::Spell spell_craft_add_item_property = nw::make_spell(654);
constexpr nw::Spell spell_craft_poison_weapon_or_ammo = nw::make_spell(655);
constexpr nw::Spell spell_craft_craft_weapon_skill = nw::make_spell(656);
constexpr nw::Spell spell_craft_craft_armor_skill = nw::make_spell(657);
constexpr nw::Spell spellability_dragon_breath_negative = nw::make_spell(698);
constexpr nw::Spell spellability_seahag_evileye = nw::make_spell(803);
constexpr nw::Spell spellability_aura_horrificappearance = nw::make_spell(804);
constexpr nw::Spell spellability_troglodyte_stench = nw::make_spell(805);
constexpr nw::Spell spell_horse_menu = nw::make_spell(812);
constexpr nw::Spell spell_horse_mount = nw::make_spell(813);
constexpr nw::Spell spell_horse_dismount = nw::make_spell(814);
constexpr nw::Spell spell_horse_party_mount = nw::make_spell(815);
constexpr nw::Spell spell_horse_party_dismount = nw::make_spell(816);
constexpr nw::Spell spell_horse_assign_mount = nw::make_spell(817);
constexpr nw::Spell spell_paladin_summon_mount = nw::make_spell(818);

} // namespace nwn1
