#####################################################################################################################################################
#---------------------------------------------------------------------------------------------------------------------------------------------------#
#	- This file is a part of 
#---------------------------------------------------------------------------------------------------------------------------------------------------#
#
#
#---------------------------------------------------------------------------------------------------------------------------------------------------#
#####################################################################################################################################################
#---------------------------------------------------------------------------------------------------------------------------------------------------#

#---------------------------------------------------------------------------------------------------------------------------------------------------#
#####################################################################################################################################################
#---------------------------------------------------------------------------------------------------------------------------------------------------#
# Load essential packages:
import multiprocessing
#from concurrent.futures import ProcessPoolExecutor as Pool
import tqdm
#---------------------------------------------------------------------------------------------------------------------------------------------------#
#####################################################################################################################################################
import multiprocessing.pool

class NoDaemonProcess(multiprocessing.Process):
    @property
    def daemon(self):
        return False

    @daemon.setter
    def daemon(self, value):
        pass


class NoDaemonContext(type(multiprocessing.get_context())):
    Process = NoDaemonProcess

# We sub-class multiprocessing.pool.Pool instead of multiprocessing.Pool
# because the latter is only a wrapper function, not a proper class.
class NestablePool(multiprocessing.pool.Pool):
    def __init__(self, *args, **kwargs):
        kwargs['context'] = NoDaemonContext()
        super(NestablePool, self).__init__(*args, **kwargs)

#####################################################################################################################################################
#---------------------------------------------------------------------------------------------------------------------------------------------------#
def multiprocess(
	function,
	args,
	return_data: bool = False,
	verbose = True,
	workers: int = None,
	):
	if workers == None:
		workers = multiprocessing.cpu_count()
	pool = multiprocessing.Pool( workers )
	tasks = ( ( function, x ) for x in args)
	data = None
	if return_data:
		data = []
		if verbose:
			for x in tqdm.tqdm( pool.imap( _worker, tasks ), total=len( args ) ):
				data.append( x )
		else:
			for x in pool.imap( _worker, tasks ):
				data.append( x )
	else:
		if verbose:
			for x in tqdm.tqdm( pool.imap( _worker, tasks ), total=len( args ) ):
				pass
		else:
			pool.imap( _worker, tasks )
	pool.close()
	pool.join()
	return data
#---------------------------------------------------------------------------------------------------------------------------------------------------#
def _worker( args ):
	function, arg = args
	return function( **arg )
#---------------------------------------------------------------------------------------------------------------------------------------------------#
#####################################################################################################################################################