# -*- coding: utf-8 -*-

"""
    mundiapi.models.update_subscription_payment_method_request

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io )
"""
import mundiapi.models.create_card_request

class UpdateSubscriptionPaymentMethodRequest(object):

    """Implementation of the 'UpdateSubscriptionPaymentMethodRequest' model.

    Request for updating a subscription's payment method

    Attributes:
        payment_method (string): The new payment method
        card_id (string): Card id
        card (CreateCardRequest): Card data

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "payment_method" : "payment_method",
        "card_id" : "card_id",
        "card" : "card"
    }

    def __init__(self,
                 payment_method=None,
                 card_id=None,
                 card=None):
        """Constructor for the UpdateSubscriptionPaymentMethodRequest class"""

        # Initialize members of the class
        self.payment_method = payment_method
        self.card_id = card_id
        self.card = card


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        payment_method = dictionary.get("payment_method")
        card_id = dictionary.get("card_id")
        card = mundiapi.models.create_card_request.CreateCardRequest.from_dictionary(dictionary.get("card")) if dictionary.get("card") else None

        # Return an object of this model
        return cls(payment_method,
                   card_id,
                   card)


