# -*- coding: utf-8 -*-

"""
    mundiapi.models.create_order_item_request

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io )
"""
import mundiapi.models.create_seller_request

class CreateOrderItemRequest(object):

    """Implementation of the 'CreateOrderItemRequest' model.

    Request for creating an order item

    Attributes:
        amount (int): Amount
        description (string): Description
        quantity (int): Quantity
        seller (CreateSellerRequest): Item seller
        seller_id (string): seller identificator

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "amount" : "amount",
        "description" : "description",
        "quantity" : "quantity",
        "seller" : "seller",
        "seller_id" : "seller_id"
    }

    def __init__(self,
                 amount=None,
                 description=None,
                 quantity=None,
                 seller=None,
                 seller_id=None):
        """Constructor for the CreateOrderItemRequest class"""

        # Initialize members of the class
        self.amount = amount
        self.description = description
        self.quantity = quantity
        self.seller = seller
        self.seller_id = seller_id


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        amount = dictionary.get("amount")
        description = dictionary.get("description")
        quantity = dictionary.get("quantity")
        seller = mundiapi.models.create_seller_request.CreateSellerRequest.from_dictionary(dictionary.get("seller")) if dictionary.get("seller") else None
        seller_id = dictionary.get("seller_id")

        # Return an object of this model
        return cls(amount,
                   description,
                   quantity,
                   seller,
                   seller_id)


