# -*- coding: utf-8 -*-

"""
    mundiapi.models.create_boleto_payment_request

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io )
"""
from mundiapi.api_helper import APIHelper
import mundiapi.models.create_address_request

class CreateBoletoPaymentRequest(object):

    """Implementation of the 'CreateBoletoPaymentRequest' model.

    Contains the settings for creating a boleto payment

    Attributes:
        retries (int): Number of retries
        bank (string): The bank code, containing three characters. The
            available codes are on the API specification
        instructions (string): The instructions field that will be printed on
            the boleto.
        due_at (datetime): Boleto due date
        billing_address (CreateAddressRequest): Card's billing address
        billing_address_id (string): The address id for the billing address

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "retries" : "retries",
        "bank" : "bank",
        "instructions" : "instructions",
        "due_at" : "due_at",
        "billing_address" : "billing_address",
        "billing_address_id" : "billing_address_id"
    }

    def __init__(self,
                 retries=None,
                 bank=None,
                 instructions=None,
                 due_at=None,
                 billing_address=None,
                 billing_address_id=None):
        """Constructor for the CreateBoletoPaymentRequest class"""

        # Initialize members of the class
        self.retries = retries
        self.bank = bank
        self.instructions = instructions
        self.due_at = APIHelper.RFC3339DateTime(due_at) if due_at else None
        self.billing_address = billing_address
        self.billing_address_id = billing_address_id


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        retries = dictionary.get("retries")
        bank = dictionary.get("bank")
        instructions = dictionary.get("instructions")
        due_at = APIHelper.RFC3339DateTime.from_value(dictionary.get("due_at")).datetime if dictionary.get("due_at") else None
        billing_address = mundiapi.models.create_address_request.CreateAddressRequest.from_dictionary(dictionary.get("billing_address")) if dictionary.get("billing_address") else None
        billing_address_id = dictionary.get("billing_address_id")

        # Return an object of this model
        return cls(retries,
                   bank,
                   instructions,
                   due_at,
                   billing_address,
                   billing_address_id)


