# -*- coding: utf-8 -*-

"""
    mundiapi.controllers.subscriptions_controller

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from .base_controller import BaseController
from ..api_helper import APIHelper
from ..configuration import Configuration
from ..http.auth.basic_auth import BasicAuth
from ..models.get_subscription_response import GetSubscriptionResponse
from ..models.get_usage_response import GetUsageResponse
from ..models.get_subscription_item_response import GetSubscriptionItemResponse
from ..models.list_subscriptions_response import ListSubscriptionsResponse
from ..models.get_discount_response import GetDiscountResponse
from ..models.list_usages_response import ListUsagesResponse

class SubscriptionsController(BaseController):

    """A Controller to access Endpoints in the mundiapi API."""


    def update_subscription_billing_date(self,
                                         subscription_id,
                                         request):
        """Does a PATCH request to /subscriptions/{subscription_id}/billing-date.

        Updates the billing date from a subscription

        Args:
            subscription_id (string): The subscription id
            request (UpdateSubscriptionBillingDateRequest): Request for
                updating the subscription billing date

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/billing-date'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def create_usage(self,
                     subscription_id,
                     item_id,
                     body):
        """Does a POST request to /subscriptions/{subscription_id}/items/{item_id}/usages.

        Creates a usage

        Args:
            subscription_id (string): Subscription Id
            item_id (string): Item id
            body (CreateUsageRequest): Request for creating a usage

        Returns:
            GetUsageResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/items/{item_id}/usages'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id,
            'item_id': item_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetUsageResponse.from_dictionary)

    def update_subscription_item(self,
                                 subscription_id,
                                 item_id,
                                 body):
        """Does a PUT request to /subscriptions/{subscription_id}/items/{item_id}.

        Updates a subscription item

        Args:
            subscription_id (string): Subscription Id
            item_id (string): Item id
            body (UpdateSubscriptionItemRequest): Request for updating a
                subscription item

        Returns:
            GetSubscriptionItemResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/items/{item_id}'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id,
            'item_id': item_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.put(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionItemResponse.from_dictionary)

    def get_subscriptions(self):
        """Does a GET request to /subscriptions.

        Gets all subscriptions

        Returns:
            ListSubscriptionsResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions'
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, ListSubscriptionsResponse.from_dictionary)

    def update_subscription_card(self,
                                 subscription_id,
                                 request):
        """Does a PATCH request to /subscriptions/{subscription_id}/card.

        Updates the credit card from a subscription

        Args:
            subscription_id (string): Subscription id
            request (UpdateSubscriptionCardRequest): Request for updating a
                card

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/card'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def create_subscription(self,
                            body):
        """Does a POST request to /subscriptions.

        Creates a new subscription

        Args:
            body (CreateSubscriptionRequest): Request for creating a
                subscription

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions'
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def create_subscription_item(self,
                                 subscription_id,
                                 request):
        """Does a POST request to /subscriptions/{subscription_id}/items.

        Creates a new Subscription item

        Args:
            subscription_id (string): Subscription id
            request (CreateSubscriptionItemRequest): Request for creating a
                subscription item

        Returns:
            GetSubscriptionItemResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/items'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionItemResponse.from_dictionary)

    def create_discount(self,
                        subscription_id,
                        request):
        """Does a POST request to /subscriptions/{subscription_id}/discounts.

        Creates a discount

        Args:
            subscription_id (string): Subscription id
            request (CreateDiscountRequest): Request for creating a discount

        Returns:
            GetDiscountResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/discounts'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetDiscountResponse.from_dictionary)

    def get_subscription(self,
                         subscription_id):
        """Does a GET request to /subscriptions/{subscription_id}.

        Gets a subscription

        Args:
            subscription_id (string): Subscription id

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def update_subscription_payment_method(self,
                                           subscription_id,
                                           request):
        """Does a PATCH request to /subscriptions/{subscription_id}/payment-method.

        Updates the payment method from a subscription

        Args:
            subscription_id (string): Subscription id
            request (UpdateSubscriptionPaymentMethodRequest): Request for
                updating the paymentmethod from a subscription

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/payment-method'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def get_usages(self,
                   subscription_id,
                   item_id):
        """Does a GET request to /subscriptions/{subscription_id}/items/{item_id}/usages.

        Lists all usages from a subscription item

        Args:
            subscription_id (string): The subscription id
            item_id (string): The subscription item id

        Returns:
            ListUsagesResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/items/{item_id}/usages'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id,
            'item_id': item_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, ListUsagesResponse.from_dictionary)

    def delete_usage(self,
                     subscription_id,
                     item_id,
                     usage_id):
        """Does a DELETE request to /subscriptions/{subscription_id}/items/{item_id}/usages/{usage_id}.

        Deletes a usage

        Args:
            subscription_id (string): The subscription id
            item_id (string): The subscription item id
            usage_id (string): The usage id

        Returns:
            GetUsageResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/items/{item_id}/usages/{usage_id}'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id,
            'item_id': item_id,
            'usage_id': usage_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.delete(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetUsageResponse.from_dictionary)

    def delete_discount(self,
                        subscription_id,
                        discount_id):
        """Does a DELETE request to /subscriptions/{subscription_id}/discounts/{discount_id}.

        Deletes a discount

        Args:
            subscription_id (string): Subscription id
            discount_id (string): Discount Id

        Returns:
            GetDiscountResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/discounts/{discount_id}'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id,
            'discount_id': discount_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.delete(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetDiscountResponse.from_dictionary)

    def cancel_subscription(self,
                            subscription_id,
                            request=None):
        """Does a DELETE request to /subscriptions/{subscription_id}.

        Cancels a subscription

        Args:
            subscription_id (string): Subscription id
            request (CreateCancelSubscriptionRequest, optional): Request for
                cancelling a subscription

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.delete(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)

    def delete_subscription_item(self,
                                 subscription_id,
                                 subscription_item_id):
        """Does a DELETE request to /subscriptions/{subscription_id}/items/{subscription_item_id}.

        Deletes a subscription item

        Args:
            subscription_id (string): Subscription id
            subscription_item_id (string): Subscription item id

        Returns:
            GetSubscriptionItemResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/subscriptions/{subscription_id}/items/{subscription_item_id}'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id,
            'subscription_item_id': subscription_item_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.delete(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionItemResponse.from_dictionary)

    def update_subscription_metadata(self,
                                     subscription_id,
                                     request):
        """Does a PATCH request to /Subscriptions/{subscription_id}/metadata.

        Updates the metadata from a subscription

        Args:
            subscription_id (string): The subscription id
            request (UpdateMetadataRequest): Request for updating the
                subscrption metadata

        Returns:
            GetSubscriptionResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/Subscriptions/{subscription_id}/metadata'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'subscription_id': subscription_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetSubscriptionResponse.from_dictionary)
