# -*- coding: utf-8 -*-

"""
    mundiapi.controllers.invoices_controller

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from .base_controller import BaseController
from ..api_helper import APIHelper
from ..configuration import Configuration
from ..http.auth.basic_auth import BasicAuth
from ..models.get_invoice_response import GetInvoiceResponse
from ..models.get_charge_response import GetChargeResponse
from ..models.list_invoices_response import ListInvoicesResponse

class InvoicesController(BaseController):

    """A Controller to access Endpoints in the mundiapi API."""


    def cancel_invoice(self,
                       invoice_id):
        """Does a DELETE request to /invoices/{invoice_id}.

        Cancels an invoice

        Args:
            invoice_id (string): Invoice id

        Returns:
            GetInvoiceResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/invoices/{invoice_id}'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'invoice_id': invoice_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.delete(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetInvoiceResponse.from_dictionary)

    def get_last_invoice_charge(self,
                                invoice_id):
        """Does a GET request to /invoices/{invoice_id}/last-charge.

        Gets the last charge from an invoice

        Args:
            invoice_id (string): Invoice id

        Returns:
            GetChargeResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/invoices/{invoice_id}/last-charge'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'invoice_id': invoice_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetChargeResponse.from_dictionary)

    def get_invoices(self):
        """Does a GET request to /invoices.

        Gets all invoices

        Returns:
            ListInvoicesResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/invoices'
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, ListInvoicesResponse.from_dictionary)

    def get_invoice(self,
                    invoice_id):
        """Does a GET request to /invoices/{invoice_id}.

        Gets an invoice

        Args:
            invoice_id (string): Invoice Id

        Returns:
            GetInvoiceResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/invoices/{invoice_id}'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'invoice_id': invoice_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetInvoiceResponse.from_dictionary)

    def update_invoice_metadata(self,
                                invoice_id,
                                request):
        """Does a PATCH request to /invoices/{invoice_id}/metadata.

        Updates the metadata from an invoice

        Args:
            invoice_id (string): The invoice id
            request (UpdateMetadataRequest): Request for updating the invoice
                metadata

        Returns:
            GetInvoiceResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _query_builder = Configuration.base_uri
        _query_builder += '/invoices/{invoice_id}/metadata'
        _query_builder = APIHelper.append_url_with_template_parameters(_query_builder, { 
            'invoice_id': invoice_id
        })
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'content-type': 'application/json; charset=utf-8'
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(request))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetInvoiceResponse.from_dictionary)
