# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from luminesce.models.data_type import DataType

class ScalarParameter(BaseModel):
    """
    Describes a scalar parameter as defined in the SQL  # noqa: E501
    """
    name:  StrictStr = Field(...,alias="name", description="Name of the scalar parameter") 
    type: DataType
    value: Optional[Any] = Field(default=None, description="the default value of the parameter")
    value_options: Optional[List[Any]] = Field(default=None, description="Values of the parameter listed as being available for choosing from.", alias="valueOptions")
    value_must_be_from_options: Optional[StrictBool] = Field(default=None, description="Must Value be one of ValueOptions (if any)?", alias="valueMustBeFromOptions")
    __properties = ["name", "type", "value", "valueOptions", "valueMustBeFromOptions"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ScalarParameter:
        """Create an instance of ScalarParameter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if value (nullable) is None
        # and __fields_set__ contains the field
        if self.value is None and "value" in self.__fields_set__:
            _dict['value'] = None

        # set to None if value_options (nullable) is None
        # and __fields_set__ contains the field
        if self.value_options is None and "value_options" in self.__fields_set__:
            _dict['valueOptions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ScalarParameter:
        """Create an instance of ScalarParameter from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ScalarParameter.parse_obj(obj)

        _obj = ScalarParameter.parse_obj({
            "name": obj.get("name"),
            "type": obj.get("type"),
            "value": obj.get("value"),
            "value_options": obj.get("valueOptions"),
            "value_must_be_from_options": obj.get("valueMustBeFromOptions")
        })
        return _obj

ScalarParameter.update_forward_refs()
