# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from luminesce.models.dashboard_type import DashboardType
from luminesce.models.date_parameters import DateParameters
from luminesce.models.resource_id import ResourceId
from luminesce.models.table_view import TableView

class LusidGridData(BaseModel):
    """
    Representation of the data we will get from the dashboard  # noqa: E501
    """
    lusid_grid_design: TableView = Field(alias="lusidGridDesign")
    resource_id: ResourceId = Field(alias="resourceId")
    dashboard_type: Optional[DashboardType] = Field(default=None, alias="dashboardType")
    use_settle_date: Optional[StrictBool] = Field(default=None, description="Whether to use the Settlement date or the Transaction date", alias="useSettleDate")
    dates: Optional[DateParameters] = None
    __properties = ["lusidGridDesign", "resourceId", "dashboardType", "useSettleDate", "dates"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LusidGridData:
        """Create an instance of LusidGridData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of lusid_grid_design
        if self.lusid_grid_design:
            _dict['lusidGridDesign'] = self.lusid_grid_design.to_dict()
        # override the default output from pydantic by calling `to_dict()` of resource_id
        if self.resource_id:
            _dict['resourceId'] = self.resource_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dates
        if self.dates:
            _dict['dates'] = self.dates.to_dict()
        # set to None if use_settle_date (nullable) is None
        # and __fields_set__ contains the field
        if self.use_settle_date is None and "use_settle_date" in self.__fields_set__:
            _dict['useSettleDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LusidGridData:
        """Create an instance of LusidGridData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LusidGridData.parse_obj(obj)

        _obj = LusidGridData.parse_obj({
            "lusid_grid_design": TableView.from_dict(obj.get("lusidGridDesign")) if obj.get("lusidGridDesign") is not None else None,
            "resource_id": ResourceId.from_dict(obj.get("resourceId")) if obj.get("resourceId") is not None else None,
            "dashboard_type": obj.get("dashboardType"),
            "use_settle_date": obj.get("useSettleDate"),
            "dates": DateParameters.from_dict(obj.get("dates")) if obj.get("dates") is not None else None
        })
        return _obj

LusidGridData.update_forward_refs()
