# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from luminesce.models.available_field import AvailableField
from luminesce.models.design_join_type import DesignJoinType
from luminesce.models.on_clause_term_design import OnClauseTermDesign

class JoinedTableDesign(BaseModel):
    """
    Treatment of a joined-to-table a QueryDesign  # noqa: E501
    """
    joined_table_name:  StrictStr = Field(...,alias="joinedTableName", description="Name of the table on the right side of the join") 
    joined_table_alias:  StrictStr = Field(...,alias="joinedTableAlias", description="Alias for the table on the right side of the join") 
    left_table_alias:  StrictStr = Field(...,alias="leftTableAlias", description="Alias for the table on the left side of the join") 
    join_type: DesignJoinType = Field(alias="joinType")
    on_clause_terms: List[OnClauseTermDesign] = Field(description="Filter clauses to apply to this join in the on clause", alias="onClauseTerms")
    right_table_available_fields: Optional[List[AvailableField]] = Field(default=None, description="Fields that are known to be available for design when parsing SQL, of the right hand table", alias="rightTableAvailableFields")
    __properties = ["joinedTableName", "joinedTableAlias", "leftTableAlias", "joinType", "onClauseTerms", "rightTableAvailableFields"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> JoinedTableDesign:
        """Create an instance of JoinedTableDesign from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in on_clause_terms (list)
        _items = []
        if self.on_clause_terms:
            for _item in self.on_clause_terms:
                if _item:
                    _items.append(_item.to_dict())
            _dict['onClauseTerms'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in right_table_available_fields (list)
        _items = []
        if self.right_table_available_fields:
            for _item in self.right_table_available_fields:
                if _item:
                    _items.append(_item.to_dict())
            _dict['rightTableAvailableFields'] = _items
        # set to None if right_table_available_fields (nullable) is None
        # and __fields_set__ contains the field
        if self.right_table_available_fields is None and "right_table_available_fields" in self.__fields_set__:
            _dict['rightTableAvailableFields'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> JoinedTableDesign:
        """Create an instance of JoinedTableDesign from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return JoinedTableDesign.parse_obj(obj)

        _obj = JoinedTableDesign.parse_obj({
            "joined_table_name": obj.get("joinedTableName"),
            "joined_table_alias": obj.get("joinedTableAlias"),
            "left_table_alias": obj.get("leftTableAlias"),
            "join_type": obj.get("joinType"),
            "on_clause_terms": [OnClauseTermDesign.from_dict(_item) for _item in obj.get("onClauseTerms")] if obj.get("onClauseTerms") is not None else None,
            "right_table_available_fields": [AvailableField.from_dict(_item) for _item in obj.get("rightTableAvailableFields")] if obj.get("rightTableAvailableFields") is not None else None
        })
        return _obj

JoinedTableDesign.update_forward_refs()
