# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from luminesce.models.cursor_position import CursorPosition

class IntellisenseRequest(BaseModel):
    """
    Representation of a request for IntellisenseItems  # noqa: E501
    """
    lines: List[StrictStr] = Field(description="The lines of text the user currently has in the editor")
    position: CursorPosition
    __properties = ["lines", "position"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IntellisenseRequest:
        """Create an instance of IntellisenseRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of position
        if self.position:
            _dict['position'] = self.position.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IntellisenseRequest:
        """Create an instance of IntellisenseRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return IntellisenseRequest.parse_obj(obj)

        _obj = IntellisenseRequest.parse_obj({
            "lines": obj.get("lines"),
            "position": CursorPosition.from_dict(obj.get("position")) if obj.get("position") is not None else None
        })
        return _obj

IntellisenseRequest.update_forward_refs()
