# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from luminesce.models.cursor_position import CursorPosition

class ErrorHighlightItem(BaseModel):
    """
    Representation of a sql error  # noqa: E501
    """
    start: CursorPosition
    stop: CursorPosition
    no_viable_alternative_start: Optional[CursorPosition] = Field(default=None, alias="noViableAlternativeStart")
    length: StrictInt = Field(description="The length of the error token counting line breaks if any")
    message:  StrictStr = Field(...,alias="message", description="The error message") 
    __properties = ["start", "stop", "noViableAlternativeStart", "length", "message"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ErrorHighlightItem:
        """Create an instance of ErrorHighlightItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of start
        if self.start:
            _dict['start'] = self.start.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stop
        if self.stop:
            _dict['stop'] = self.stop.to_dict()
        # override the default output from pydantic by calling `to_dict()` of no_viable_alternative_start
        if self.no_viable_alternative_start:
            _dict['noViableAlternativeStart'] = self.no_viable_alternative_start.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ErrorHighlightItem:
        """Create an instance of ErrorHighlightItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ErrorHighlightItem.parse_obj(obj)

        _obj = ErrorHighlightItem.parse_obj({
            "start": CursorPosition.from_dict(obj.get("start")) if obj.get("start") is not None else None,
            "stop": CursorPosition.from_dict(obj.get("stop")) if obj.get("stop") is not None else None,
            "no_viable_alternative_start": CursorPosition.from_dict(obj.get("noViableAlternativeStart")) if obj.get("noViableAlternativeStart") is not None else None,
            "length": obj.get("length"),
            "message": obj.get("message")
        })
        return _obj

ErrorHighlightItem.update_forward_refs()
