# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from luminesce.models.condition_attributes import ConditionAttributes
from luminesce.models.data_type import DataType

class Column(BaseModel):
    """
    Column
    """
    is_primary_key: Optional[StrictBool] = Field(default=None, alias="isPrimaryKey")
    is_main: Optional[StrictBool] = Field(default=None, alias="isMain")
    is_required_by_provider: Optional[StrictBool] = Field(default=None, alias="isRequiredByProvider")
    mandatory_for_actions:  Optional[StrictStr] = Field(None,alias="mandatoryForActions") 
    name:  Optional[StrictStr] = Field(None,alias="name") 
    type: Optional[DataType] = None
    description:  Optional[StrictStr] = Field(None,alias="description") 
    display_name:  Optional[StrictStr] = Field(None,alias="displayName") 
    condition_usage: Optional[ConditionAttributes] = Field(default=None, alias="conditionUsage")
    sample_values:  Optional[StrictStr] = Field(None,alias="sampleValues") 
    allowed_values:  Optional[StrictStr] = Field(None,alias="allowedValues") 
    __properties = ["isPrimaryKey", "isMain", "isRequiredByProvider", "mandatoryForActions", "name", "type", "description", "displayName", "conditionUsage", "sampleValues", "allowedValues"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Column:
        """Create an instance of Column from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if mandatory_for_actions (nullable) is None
        # and __fields_set__ contains the field
        if self.mandatory_for_actions is None and "mandatory_for_actions" in self.__fields_set__:
            _dict['mandatoryForActions'] = None

        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if display_name (nullable) is None
        # and __fields_set__ contains the field
        if self.display_name is None and "display_name" in self.__fields_set__:
            _dict['displayName'] = None

        # set to None if sample_values (nullable) is None
        # and __fields_set__ contains the field
        if self.sample_values is None and "sample_values" in self.__fields_set__:
            _dict['sampleValues'] = None

        # set to None if allowed_values (nullable) is None
        # and __fields_set__ contains the field
        if self.allowed_values is None and "allowed_values" in self.__fields_set__:
            _dict['allowedValues'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Column:
        """Create an instance of Column from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Column.parse_obj(obj)

        _obj = Column.parse_obj({
            "is_primary_key": obj.get("isPrimaryKey"),
            "is_main": obj.get("isMain"),
            "is_required_by_provider": obj.get("isRequiredByProvider"),
            "mandatory_for_actions": obj.get("mandatoryForActions"),
            "name": obj.get("name"),
            "type": obj.get("type"),
            "description": obj.get("description"),
            "display_name": obj.get("displayName"),
            "condition_usage": obj.get("conditionUsage"),
            "sample_values": obj.get("sampleValues"),
            "allowed_values": obj.get("allowedValues")
        })
        return _obj

Column.update_forward_refs()
