# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.folder_metadata import FolderMetadata
from solomonai_backend_client_sdk.models.workspace_activity import WorkspaceActivity
from solomonai_backend_client_sdk.models.workspace_compliance import WorkspaceCompliance
from solomonai_backend_client_sdk.models.workspace_sharing import WorkspaceSharing
from typing import Optional, Set
from typing_extensions import Self

class Workspace(BaseModel):
    """
    Workspace represents a collaborative environment for file organization. Provides a container for folders and files with specific sharing and access controls.  Key features: - Resource organization - Access control - Usage tracking - Collaboration settings - Compliance management  Security features: - Public sharing controls - Member limits - Approval workflows - Guest access management  Storage features: - Quota management - Size limits - Version control - Retention policies
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    tags: Optional[List[StrictStr]] = None
    folders: Optional[List[FolderMetadata]] = None
    version: Optional[StrictInt] = None
    is_deleted: Optional[StrictBool] = Field(default=None, alias="isDeleted")
    s3_bucket_name: Optional[StrictStr] = Field(default=None, description="The S3 bucket name where the folder is located.", alias="s3BucketName")
    s3_folder_path: Optional[StrictStr] = Field(default=None, description="The prefix path representing the folder in the S3 bucket.", alias="s3FolderPath")
    s3_region: Optional[StrictStr] = Field(default=None, description="AWS region where the S3 bucket containing the folder is located.", alias="s3Region")
    s3_metadata: Optional[Dict[str, StrictStr]] = Field(default=None, description="Custom metadata for the folder, represented as key-value pairs.", alias="s3Metadata")
    s3_acl: Optional[StrictStr] = Field(default=None, description="Access control list (ACL) permissions for the folder in S3.", alias="s3Acl")
    s3_last_modified: Optional[datetime] = Field(default=None, description="The date and time when the folder was last modified in S3. This might represent the last time a file was added, removed, or changed in the folder.", alias="s3LastModified")
    unique_identifier: Optional[StrictStr] = Field(default=None, alias="uniqueIdentifier")
    version_id: Optional[StrictStr] = Field(default=None, alias="versionId")
    description: Optional[StrictStr] = None
    metadata_json: Optional[StrictStr] = Field(default=None, alias="metadataJson")
    storage_quota: Optional[StrictStr] = Field(default=None, alias="storageQuota")
    used_storage: Optional[StrictStr] = Field(default=None, alias="usedStorage")
    tenant_id: Optional[StrictStr] = Field(default=None, alias="tenantId")
    organization_id: Optional[StrictStr] = Field(default=None, alias="organizationId")
    workspace_type: Optional[StrictStr] = Field(default=None, alias="workspaceType")
    parent_workspace_id: Optional[StrictStr] = Field(default=None, alias="parentWorkspaceId")
    workspace_path: Optional[StrictStr] = Field(default=None, alias="workspacePath")
    icon_url: Optional[StrictStr] = Field(default=None, alias="iconUrl")
    color_theme: Optional[StrictStr] = Field(default=None, alias="colorTheme")
    is_template: Optional[StrictBool] = Field(default=None, alias="isTemplate")
    template_id: Optional[StrictStr] = Field(default=None, alias="templateId")
    favorite_count: Optional[StrictInt] = Field(default=None, alias="favoriteCount")
    last_activity: Optional[datetime] = Field(default=None, alias="lastActivity")
    retention_days: Optional[StrictInt] = Field(default=None, alias="retentionDays")
    default_view: Optional[StrictStr] = Field(default=None, alias="defaultView")
    max_file_size: Optional[StrictStr] = Field(default=None, alias="maxFileSize")
    max_storage_per_user: Optional[StrictStr] = Field(default=None, alias="maxStoragePerUser")
    max_versions: Optional[StrictInt] = Field(default=None, alias="maxVersions")
    allow_public_sharing: Optional[StrictBool] = Field(default=None, alias="allowPublicSharing")
    require_approval: Optional[StrictBool] = Field(default=None, alias="requireApproval")
    member_limit: Optional[StrictInt] = Field(default=None, alias="memberLimit")
    guest_access: Optional[StrictBool] = Field(default=None, alias="guestAccess")
    sharing: Optional[List[WorkspaceSharing]] = None
    activity: Optional[List[WorkspaceActivity]] = None
    compliance: Optional[List[WorkspaceCompliance]] = None
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "name", "createdAt", "updatedAt", "tags", "folders", "version", "isDeleted", "s3BucketName", "s3FolderPath", "s3Region", "s3Metadata", "s3Acl", "s3LastModified", "uniqueIdentifier", "versionId", "description", "metadataJson", "storageQuota", "usedStorage", "tenantId", "organizationId", "workspaceType", "parentWorkspaceId", "workspacePath", "iconUrl", "colorTheme", "isTemplate", "templateId", "favoriteCount", "lastActivity", "retentionDays", "defaultView", "maxFileSize", "maxStoragePerUser", "maxVersions", "allowPublicSharing", "requireApproval", "memberLimit", "guestAccess", "sharing", "activity", "compliance", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Workspace from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in folders (list)
        _items = []
        if self.folders:
            for _item in self.folders:
                if _item:
                    _items.append(_item.to_dict())
            _dict['folders'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in sharing (list)
        _items = []
        if self.sharing:
            for _item in self.sharing:
                if _item:
                    _items.append(_item.to_dict())
            _dict['sharing'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in activity (list)
        _items = []
        if self.activity:
            for _item in self.activity:
                if _item:
                    _items.append(_item.to_dict())
            _dict['activity'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in compliance (list)
        _items = []
        if self.compliance:
            for _item in self.compliance:
                if _item:
                    _items.append(_item.to_dict())
            _dict['compliance'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Workspace from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "tags": obj.get("tags"),
            "folders": [FolderMetadata.from_dict(_item) for _item in obj["folders"]] if obj.get("folders") is not None else None,
            "version": obj.get("version"),
            "isDeleted": obj.get("isDeleted"),
            "s3BucketName": obj.get("s3BucketName"),
            "s3FolderPath": obj.get("s3FolderPath"),
            "s3Region": obj.get("s3Region"),
            "s3Metadata": obj.get("s3Metadata"),
            "s3Acl": obj.get("s3Acl"),
            "s3LastModified": obj.get("s3LastModified"),
            "uniqueIdentifier": obj.get("uniqueIdentifier"),
            "versionId": obj.get("versionId"),
            "description": obj.get("description"),
            "metadataJson": obj.get("metadataJson"),
            "storageQuota": obj.get("storageQuota"),
            "usedStorage": obj.get("usedStorage"),
            "tenantId": obj.get("tenantId"),
            "organizationId": obj.get("organizationId"),
            "workspaceType": obj.get("workspaceType"),
            "parentWorkspaceId": obj.get("parentWorkspaceId"),
            "workspacePath": obj.get("workspacePath"),
            "iconUrl": obj.get("iconUrl"),
            "colorTheme": obj.get("colorTheme"),
            "isTemplate": obj.get("isTemplate"),
            "templateId": obj.get("templateId"),
            "favoriteCount": obj.get("favoriteCount"),
            "lastActivity": obj.get("lastActivity"),
            "retentionDays": obj.get("retentionDays"),
            "defaultView": obj.get("defaultView"),
            "maxFileSize": obj.get("maxFileSize"),
            "maxStoragePerUser": obj.get("maxStoragePerUser"),
            "maxVersions": obj.get("maxVersions"),
            "allowPublicSharing": obj.get("allowPublicSharing"),
            "requireApproval": obj.get("requireApproval"),
            "memberLimit": obj.get("memberLimit"),
            "guestAccess": obj.get("guestAccess"),
            "sharing": [WorkspaceSharing.from_dict(_item) for _item in obj["sharing"]] if obj.get("sharing") is not None else None,
            "activity": [WorkspaceActivity.from_dict(_item) for _item in obj["activity"]] if obj.get("activity") is not None else None,
            "compliance": [WorkspaceCompliance.from_dict(_item) for _item in obj["compliance"]] if obj.get("compliance") is not None else None,
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


