# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from solomonai_backend_client_sdk.models.vendor_credit_line import VendorCreditLine
from typing import Optional, Set
from typing_extensions import Self

class VendorCredit(BaseModel):
    """
    The VendorCredit object represents an accounts receivable transaction indicating that a customer is owed a gift or refund. It includes details such as the amount of credit, the vendor responsible, the associated account, and other relevant information.
    """ # noqa: E501
    merge_record_id: Optional[StrictStr] = Field(default=None, alias="mergeRecordId")
    remote_id: Optional[StrictStr] = Field(default=None, alias="remoteId")
    number: Optional[StrictStr] = None
    transaction_date: Optional[datetime] = Field(default=None, alias="transactionDate")
    vendor: Optional[StrictStr] = None
    total_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="totalAmount")
    currency: Optional[StrictStr] = None
    exchange_rate: Optional[StrictStr] = Field(default=None, alias="exchangeRate")
    company: Optional[StrictStr] = None
    lines: Optional[List[VendorCreditLine]] = None
    tracking_categories: Optional[List[StrictStr]] = Field(default=None, alias="trackingCategories")
    remote_was_deleted: Optional[StrictBool] = Field(default=None, alias="remoteWasDeleted")
    accounting_period: Optional[StrictStr] = Field(default=None, alias="accountingPeriod")
    modified_at: Optional[datetime] = Field(default=None, alias="modifiedAt")
    id: Optional[StrictStr] = None
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["mergeRecordId", "remoteId", "number", "transactionDate", "vendor", "totalAmount", "currency", "exchangeRate", "company", "lines", "trackingCategories", "remoteWasDeleted", "accountingPeriod", "modifiedAt", "id", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VendorCredit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in lines (list)
        _items = []
        if self.lines:
            for _item in self.lines:
                if _item:
                    _items.append(_item.to_dict())
            _dict['lines'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VendorCredit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "mergeRecordId": obj.get("mergeRecordId"),
            "remoteId": obj.get("remoteId"),
            "number": obj.get("number"),
            "transactionDate": obj.get("transactionDate"),
            "vendor": obj.get("vendor"),
            "totalAmount": obj.get("totalAmount"),
            "currency": obj.get("currency"),
            "exchangeRate": obj.get("exchangeRate"),
            "company": obj.get("company"),
            "lines": [VendorCreditLine.from_dict(_item) for _item in obj["lines"]] if obj.get("lines") is not None else None,
            "trackingCategories": obj.get("trackingCategories"),
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "accountingPeriod": obj.get("accountingPeriod"),
            "modifiedAt": obj.get("modifiedAt"),
            "id": obj.get("id"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


