# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from solomonai_backend_client_sdk.models.any import Any
from solomonai_backend_client_sdk.models.financial_user_profile_type import FinancialUserProfileType
from typing import Optional, Set
from typing_extensions import Self

class Transaction(BaseModel):
    """
    Transaction
    """ # noqa: E501
    account_id: Optional[StrictStr] = Field(default=None, alias="accountId")
    amount: Optional[Union[StrictFloat, StrictInt]] = None
    iso_currency_code: Optional[StrictStr] = Field(default=None, alias="isoCurrencyCode")
    unofficial_currency_code: Optional[StrictStr] = Field(default=None, alias="unofficialCurrencyCode")
    category_id: Optional[StrictStr] = Field(default=None, alias="categoryId")
    check_number: Optional[StrictStr] = Field(default=None, alias="checkNumber")
    current_date: Optional[StrictStr] = Field(default=None, alias="currentDate")
    current_datetime: Optional[StrictStr] = Field(default=None, alias="currentDatetime")
    authorized_date: Optional[StrictStr] = Field(default=None, alias="authorizedDate")
    authorized_datetime: Optional[StrictStr] = Field(default=None, alias="authorizedDatetime")
    name: Optional[StrictStr] = None
    merchant_name: Optional[StrictStr] = Field(default=None, alias="merchantName")
    payment_channel: Optional[StrictStr] = Field(default=None, alias="paymentChannel")
    pending: Optional[StrictBool] = None
    pending_transaction_id: Optional[StrictStr] = Field(default=None, alias="pendingTransactionId")
    account_owner: Optional[StrictStr] = Field(default=None, alias="accountOwner")
    transaction_id: Optional[StrictStr] = Field(default=None, alias="transactionId")
    transaction_code: Optional[StrictStr] = Field(default=None, alias="transactionCode")
    id: Optional[StrictStr] = None
    user_id: Optional[StrictStr] = Field(default=None, alias="userId")
    link_id: Optional[StrictStr] = Field(default=None, alias="linkId")
    sign: Optional[StrictInt] = None
    personal_finance_category_primary: Optional[StrictStr] = Field(default=None, alias="personalFinanceCategoryPrimary")
    personal_finance_category_detailed: Optional[StrictStr] = Field(default=None, alias="personalFinanceCategoryDetailed")
    location_address: Optional[StrictStr] = Field(default=None, alias="locationAddress")
    location_city: Optional[StrictStr] = Field(default=None, alias="locationCity")
    location_region: Optional[StrictStr] = Field(default=None, alias="locationRegion")
    location_postal_code: Optional[StrictStr] = Field(default=None, alias="locationPostalCode")
    location_country: Optional[StrictStr] = Field(default=None, alias="locationCountry")
    location_lat: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="locationLat")
    location_lon: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="locationLon")
    location_store_number: Optional[StrictStr] = Field(default=None, alias="locationStoreNumber")
    payment_meta_by_order_of: Optional[StrictStr] = Field(default=None, alias="paymentMetaByOrderOf")
    payment_meta_payee: Optional[StrictStr] = Field(default=None, alias="paymentMetaPayee")
    payment_meta_payer: Optional[StrictStr] = Field(default=None, alias="paymentMetaPayer")
    payment_meta_payment_method: Optional[StrictStr] = Field(default=None, alias="paymentMetaPaymentMethod")
    payment_meta_payment_processor: Optional[StrictStr] = Field(default=None, alias="paymentMetaPaymentProcessor")
    payment_meta_ppd_id: Optional[StrictStr] = Field(default=None, alias="paymentMetaPpdId")
    payment_meta_reason: Optional[StrictStr] = Field(default=None, alias="paymentMetaReason")
    payment_meta_reference_number: Optional[StrictStr] = Field(default=None, alias="paymentMetaReferenceNumber")
    time: Optional[datetime] = None
    additional_properties: Optional[Any] = Field(default=None, alias="additionalProperties")
    categories: Optional[List[StrictStr]] = None
    profile_type: Optional[FinancialUserProfileType] = Field(default=FinancialUserProfileType.UNSPECIFIED, alias="profileType")
    __properties: ClassVar[List[str]] = ["accountId", "amount", "isoCurrencyCode", "unofficialCurrencyCode", "categoryId", "checkNumber", "currentDate", "currentDatetime", "authorizedDate", "authorizedDatetime", "name", "merchantName", "paymentChannel", "pending", "pendingTransactionId", "accountOwner", "transactionId", "transactionCode", "id", "userId", "linkId", "sign", "personalFinanceCategoryPrimary", "personalFinanceCategoryDetailed", "locationAddress", "locationCity", "locationRegion", "locationPostalCode", "locationCountry", "locationLat", "locationLon", "locationStoreNumber", "paymentMetaByOrderOf", "paymentMetaPayee", "paymentMetaPayer", "paymentMetaPaymentMethod", "paymentMetaPaymentProcessor", "paymentMetaPpdId", "paymentMetaReason", "paymentMetaReferenceNumber", "time", "additionalProperties", "categories", "profileType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Transaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of additional_properties
        if self.additional_properties:
            _dict['additionalProperties'] = self.additional_properties.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Transaction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accountId": obj.get("accountId"),
            "amount": obj.get("amount"),
            "isoCurrencyCode": obj.get("isoCurrencyCode"),
            "unofficialCurrencyCode": obj.get("unofficialCurrencyCode"),
            "categoryId": obj.get("categoryId"),
            "checkNumber": obj.get("checkNumber"),
            "currentDate": obj.get("currentDate"),
            "currentDatetime": obj.get("currentDatetime"),
            "authorizedDate": obj.get("authorizedDate"),
            "authorizedDatetime": obj.get("authorizedDatetime"),
            "name": obj.get("name"),
            "merchantName": obj.get("merchantName"),
            "paymentChannel": obj.get("paymentChannel"),
            "pending": obj.get("pending"),
            "pendingTransactionId": obj.get("pendingTransactionId"),
            "accountOwner": obj.get("accountOwner"),
            "transactionId": obj.get("transactionId"),
            "transactionCode": obj.get("transactionCode"),
            "id": obj.get("id"),
            "userId": obj.get("userId"),
            "linkId": obj.get("linkId"),
            "sign": obj.get("sign"),
            "personalFinanceCategoryPrimary": obj.get("personalFinanceCategoryPrimary"),
            "personalFinanceCategoryDetailed": obj.get("personalFinanceCategoryDetailed"),
            "locationAddress": obj.get("locationAddress"),
            "locationCity": obj.get("locationCity"),
            "locationRegion": obj.get("locationRegion"),
            "locationPostalCode": obj.get("locationPostalCode"),
            "locationCountry": obj.get("locationCountry"),
            "locationLat": obj.get("locationLat"),
            "locationLon": obj.get("locationLon"),
            "locationStoreNumber": obj.get("locationStoreNumber"),
            "paymentMetaByOrderOf": obj.get("paymentMetaByOrderOf"),
            "paymentMetaPayee": obj.get("paymentMetaPayee"),
            "paymentMetaPayer": obj.get("paymentMetaPayer"),
            "paymentMetaPaymentMethod": obj.get("paymentMetaPaymentMethod"),
            "paymentMetaPaymentProcessor": obj.get("paymentMetaPaymentProcessor"),
            "paymentMetaPpdId": obj.get("paymentMetaPpdId"),
            "paymentMetaReason": obj.get("paymentMetaReason"),
            "paymentMetaReferenceNumber": obj.get("paymentMetaReferenceNumber"),
            "time": obj.get("time"),
            "additionalProperties": Any.from_dict(obj["additionalProperties"]) if obj.get("additionalProperties") is not None else None,
            "categories": obj.get("categories"),
            "profileType": obj.get("profileType") if obj.get("profileType") is not None else FinancialUserProfileType.UNSPECIFIED
        })
        return _obj


