# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.api_key_environment import APIKeyEnvironment
from solomonai_backend_client_sdk.models.api_permission import ApiPermission
from solomonai_backend_client_sdk.models.scope_type import ScopeType
from typing import Optional, Set
from typing_extensions import Self

class TenantAPIKey(BaseModel):
    """
    TenantAPIKey
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the tenant API key.")
    key_name: StrictStr = Field(description="Name of the API key.", alias="keyName")
    key_prefix: StrictStr = Field(description="Prefix of the API key.", alias="keyPrefix")
    key_hash: Optional[StrictStr] = Field(default=None, description="Hashed API key.", alias="keyHash")
    key_id: StrictStr = Field(description="Unique key identifier.", alias="keyId")
    scopes: Optional[List[ScopeType]] = Field(default=None, description="Scopes assigned to the API key.")
    expires_at: Optional[datetime] = Field(default=None, description="Expiration date of the key.", alias="expiresAt")
    created_at: Optional[datetime] = Field(default=None, description="Timestamp when the key was created.", alias="createdAt")
    created_by: Optional[StrictStr] = Field(default=None, description="ID of the creator.", alias="createdBy")
    last_used: Optional[datetime] = Field(default=None, description="Timestamp when the key was last used.", alias="lastUsed")
    is_active: Optional[StrictBool] = Field(default=None, description="Indicates if the key is active.", alias="isActive")
    environment: Optional[APIKeyEnvironment] = APIKeyEnvironment.UNSPECIFIED
    rate_limit: Optional[StrictInt] = Field(default=None, alias="rateLimit")
    allowed_ips: Optional[List[StrictStr]] = Field(default=None, description="Allowed IP addresses (supports both IPv4 and IPv6 with CIDR notation).", alias="allowedIps")
    allowed_domains: Optional[List[StrictStr]] = Field(default=None, description="Allowed domains.", alias="allowedDomains")
    permissions: Optional[List[ApiPermission]] = None
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "keyName", "keyPrefix", "keyHash", "keyId", "scopes", "expiresAt", "createdAt", "createdBy", "lastUsed", "isActive", "environment", "rateLimit", "allowedIps", "allowedDomains", "permissions", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TenantAPIKey from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in permissions (list)
        _items = []
        if self.permissions:
            for _item in self.permissions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['permissions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TenantAPIKey from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "keyName": obj.get("keyName"),
            "keyPrefix": obj.get("keyPrefix"),
            "keyHash": obj.get("keyHash"),
            "keyId": obj.get("keyId"),
            "scopes": obj.get("scopes"),
            "expiresAt": obj.get("expiresAt"),
            "createdAt": obj.get("createdAt"),
            "createdBy": obj.get("createdBy"),
            "lastUsed": obj.get("lastUsed"),
            "isActive": obj.get("isActive"),
            "environment": obj.get("environment") if obj.get("environment") is not None else APIKeyEnvironment.UNSPECIFIED,
            "rateLimit": obj.get("rateLimit"),
            "allowedIps": obj.get("allowedIps"),
            "allowedDomains": obj.get("allowedDomains"),
            "permissions": [ApiPermission.from_dict(_item) for _item in obj["permissions"]] if obj.get("permissions") is not None else None,
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


