# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.address import Address
from solomonai_backend_client_sdk.models.audit_log import AuditLog
from solomonai_backend_client_sdk.models.settings import Settings
from solomonai_backend_client_sdk.models.tenant_api_key import TenantAPIKey
from solomonai_backend_client_sdk.models.tenant_status import TenantStatus
from solomonai_backend_client_sdk.models.tenant_type import TenantType
from solomonai_backend_client_sdk.models.tenant_usage_log import TenantUsageLog
from typing import Optional, Set
from typing_extensions import Self

class Tenant(BaseModel):
    """
    Tenant
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the tenant (UUID format).")
    display_name: Optional[StrictStr] = Field(default=None, description="Display name of the tenant, used for UI display purposes.", alias="displayName")
    external_id: Optional[StrictStr] = Field(default=None, description="External ID for the tenant, e.g., ID from an external or third-party system.", alias="externalId")
    tenant_type: Optional[TenantType] = Field(default=TenantType.UNSPECIFIED, alias="tenantType")
    status: Optional[TenantStatus] = TenantStatus.UNSPECIFIED
    created_at: Optional[datetime] = Field(default=None, description="Timestamp indicating when the tenant was created.", alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, description="Timestamp indicating the last update time for the tenant.", alias="updatedAt")
    storage_quota: Optional[StrictStr] = Field(default=None, description="Storage quota for the tenant, specified in bytes.", alias="storageQuota")
    used_storage: Optional[StrictStr] = Field(default=None, description="Storage used by the tenant, specified in bytes.", alias="usedStorage")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="Metadata in structured format for flexible storage of additional details.")
    custom_domain: Optional[StrictStr] = Field(default=None, description="Custom domain associated with the tenant, if applicable.", alias="customDomain")
    email: StrictStr = Field(description="Primary contact email for the tenant.")
    is_soft_deleted: Optional[StrictBool] = Field(default=None, description="Indicates if the tenant is soft-deleted.", alias="isSoftDeleted")
    is_active: Optional[StrictBool] = Field(default=None, description="Indicates if the tenant is currently active.", alias="isActive")
    address: Optional[Address] = None
    phone_number: Optional[StrictStr] = Field(default=None, description="Phone number for contacting the tenant.", alias="phoneNumber")
    timezone: Optional[StrictStr] = Field(default=None, description="Timezone setting for the tenant.")
    language_code: Optional[StrictStr] = Field(default=None, description="Language preference code for the tenant (e.g., \"en-US\").", alias="languageCode")
    compliance_requirements: Optional[List[StrictStr]] = Field(default=None, description="Compliance requirements specific to the tenant, stored as a list of strings.", alias="complianceRequirements")
    feature_flags: Optional[Dict[str, Any]] = Field(default=None, description="Feature flags enabled for the tenant, providing feature-level customization.", alias="featureFlags")
    security_settings: Optional[Dict[str, Any]] = Field(default=None, description="Security settings specific to the tenant, allowing flexible security configurations.", alias="securitySettings")
    owner_user_id: Optional[StrictStr] = Field(default=None, description="User ID of the tenant's owner or primary administrator.", alias="ownerUserId")
    deleted_at: Optional[datetime] = Field(default=None, description="Timestamp for when the tenant was soft-deleted.", alias="deletedAt")
    business_accounts: Optional[List[BusinessAccount]] = Field(default=None, description="Business accounts associated with the tenant.", alias="businessAccounts")
    user_accounts: Optional[List[UserAccount]] = Field(default=None, description="User accounts associated with the tenant.", alias="userAccounts")
    settings: Optional[Settings] = None
    audit_logs: Optional[List[AuditLog]] = Field(default=None, description="Audit logs for tracking organizational events, changes, and security.", alias="auditLogs")
    tenant_api_keys: Optional[List[TenantAPIKey]] = Field(default=None, description="API keys associated with the tenant, for service integrations and API access.", alias="tenantApiKeys")
    tenant_usage_logs: Optional[List[TenantUsageLog]] = Field(default=None, description="Usage logs for the tenant, tracking resource consumption.", alias="tenantUsageLogs")
    record_id_reference: Optional[StrictStr] = Field(default=None, alias="recordIdReference")
    __properties: ClassVar[List[str]] = ["id", "displayName", "externalId", "tenantType", "status", "createdAt", "updatedAt", "storageQuota", "usedStorage", "metadata", "customDomain", "email", "isSoftDeleted", "isActive", "address", "phoneNumber", "timezone", "languageCode", "complianceRequirements", "featureFlags", "securitySettings", "ownerUserId", "deletedAt", "businessAccounts", "userAccounts", "settings", "auditLogs", "tenantApiKeys", "tenantUsageLogs", "recordIdReference"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Tenant from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in business_accounts (list)
        _items = []
        if self.business_accounts:
            for _item in self.business_accounts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['businessAccounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in user_accounts (list)
        _items = []
        if self.user_accounts:
            for _item in self.user_accounts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['userAccounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of settings
        if self.settings:
            _dict['settings'] = self.settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in audit_logs (list)
        _items = []
        if self.audit_logs:
            for _item in self.audit_logs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['auditLogs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tenant_api_keys (list)
        _items = []
        if self.tenant_api_keys:
            for _item in self.tenant_api_keys:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tenantApiKeys'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tenant_usage_logs (list)
        _items = []
        if self.tenant_usage_logs:
            for _item in self.tenant_usage_logs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tenantUsageLogs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Tenant from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "displayName": obj.get("displayName"),
            "externalId": obj.get("externalId"),
            "tenantType": obj.get("tenantType") if obj.get("tenantType") is not None else TenantType.UNSPECIFIED,
            "status": obj.get("status") if obj.get("status") is not None else TenantStatus.UNSPECIFIED,
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "storageQuota": obj.get("storageQuota"),
            "usedStorage": obj.get("usedStorage"),
            "metadata": obj.get("metadata"),
            "customDomain": obj.get("customDomain"),
            "email": obj.get("email"),
            "isSoftDeleted": obj.get("isSoftDeleted"),
            "isActive": obj.get("isActive"),
            "address": Address.from_dict(obj["address"]) if obj.get("address") is not None else None,
            "phoneNumber": obj.get("phoneNumber"),
            "timezone": obj.get("timezone"),
            "languageCode": obj.get("languageCode"),
            "complianceRequirements": obj.get("complianceRequirements"),
            "featureFlags": obj.get("featureFlags"),
            "securitySettings": obj.get("securitySettings"),
            "ownerUserId": obj.get("ownerUserId"),
            "deletedAt": obj.get("deletedAt"),
            "businessAccounts": [BusinessAccount.from_dict(_item) for _item in obj["businessAccounts"]] if obj.get("businessAccounts") is not None else None,
            "userAccounts": [UserAccount.from_dict(_item) for _item in obj["userAccounts"]] if obj.get("userAccounts") is not None else None,
            "settings": Settings.from_dict(obj["settings"]) if obj.get("settings") is not None else None,
            "auditLogs": [AuditLog.from_dict(_item) for _item in obj["auditLogs"]] if obj.get("auditLogs") is not None else None,
            "tenantApiKeys": [TenantAPIKey.from_dict(_item) for _item in obj["tenantApiKeys"]] if obj.get("tenantApiKeys") is not None else None,
            "tenantUsageLogs": [TenantUsageLog.from_dict(_item) for _item in obj["tenantUsageLogs"]] if obj.get("tenantUsageLogs") is not None else None,
            "recordIdReference": obj.get("recordIdReference")
        })
        return _obj

from solomonai_backend_client_sdk.models.business_account import BusinessAccount
from solomonai_backend_client_sdk.models.user_account import UserAccount
# TODO: Rewrite to not use raise_errors
Tenant.model_rebuild(raise_errors=False)

