# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.business_account import BusinessAccount
from solomonai_backend_client_sdk.models.ownership_permission import OwnershipPermission
from solomonai_backend_client_sdk.models.ownership_transfer import OwnershipTransfer
from typing import Optional, Set
from typing_extensions import Self

class TeamOwnership(BaseModel):
    """
    TeamOwnership
    """ # noqa: E501
    id: Optional[StrictStr] = None
    admin: Optional[BusinessAccount] = None
    permissions: Optional[List[OwnershipPermission]] = None
    granted_at: Optional[datetime] = Field(default=None, alias="grantedAt")
    ownership_histories: Optional[List[OwnershipTransfer]] = Field(default=None, alias="ownershipHistories")
    __properties: ClassVar[List[str]] = ["id", "admin", "permissions", "grantedAt", "ownershipHistories"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TeamOwnership from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of admin
        if self.admin:
            _dict['admin'] = self.admin.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in permissions (list)
        _items = []
        if self.permissions:
            for _item in self.permissions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['permissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in ownership_histories (list)
        _items = []
        if self.ownership_histories:
            for _item in self.ownership_histories:
                if _item:
                    _items.append(_item.to_dict())
            _dict['ownershipHistories'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TeamOwnership from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "admin": BusinessAccount.from_dict(obj["admin"]) if obj.get("admin") is not None else None,
            "permissions": [OwnershipPermission.from_dict(_item) for _item in obj["permissions"]] if obj.get("permissions") is not None else None,
            "grantedAt": obj.get("grantedAt"),
            "ownershipHistories": [OwnershipTransfer.from_dict(_item) for _item in obj["ownershipHistories"]] if obj.get("ownershipHistories") is not None else None
        })
        return _obj


