# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.application_theme import ApplicationTheme
from solomonai_backend_client_sdk.models.digital_worker_settings import DigitalWorkerSettings
from solomonai_backend_client_sdk.models.financial_preferences import FinancialPreferences
from solomonai_backend_client_sdk.models.liked_dashboard_panels import LikedDashboardPanels
from solomonai_backend_client_sdk.models.notification_settings import NotificationSettings
from solomonai_backend_client_sdk.models.risk_tolerance_settings import RiskToleranceSettings
from typing import Optional, Set
from typing_extensions import Self

class Settings(BaseModel):
    """
    Represents user-specific settings within the fintech application.
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the user settings.")
    app_theme: Optional[ApplicationTheme] = Field(default=ApplicationTheme.UNSPECIFIED, alias="appTheme")
    notification_settings: Optional[NotificationSettings] = Field(default=None, alias="notificationSettings")
    preferred_language: Optional[StrictStr] = Field(default=None, description="Preferred language for the application, e.g., \"en\" for English.", alias="preferredLanguage")
    risk_tolerance: Optional[RiskToleranceSettings] = Field(default=RiskToleranceSettings.UNSPECIFIED, alias="riskTolerance")
    liked_dashboard_panels: Optional[List[LikedDashboardPanels]] = Field(default=None, description="List of preferred dashboard panels for customization, allowing users to select specific widgets or reports.", alias="likedDashboardPanels")
    digital_worker_settings: Optional[DigitalWorkerSettings] = Field(default=None, alias="digitalWorkerSettings")
    financial_preferences: Optional[FinancialPreferences] = Field(default=None, alias="financialPreferences")
    __properties: ClassVar[List[str]] = ["id", "appTheme", "notificationSettings", "preferredLanguage", "riskTolerance", "likedDashboardPanels", "digitalWorkerSettings", "financialPreferences"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Settings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of notification_settings
        if self.notification_settings:
            _dict['notificationSettings'] = self.notification_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of digital_worker_settings
        if self.digital_worker_settings:
            _dict['digitalWorkerSettings'] = self.digital_worker_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of financial_preferences
        if self.financial_preferences:
            _dict['financialPreferences'] = self.financial_preferences.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Settings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "appTheme": obj.get("appTheme") if obj.get("appTheme") is not None else ApplicationTheme.UNSPECIFIED,
            "notificationSettings": NotificationSettings.from_dict(obj["notificationSettings"]) if obj.get("notificationSettings") is not None else None,
            "preferredLanguage": obj.get("preferredLanguage"),
            "riskTolerance": obj.get("riskTolerance") if obj.get("riskTolerance") is not None else RiskToleranceSettings.UNSPECIFIED,
            "likedDashboardPanels": obj.get("likedDashboardPanels"),
            "digitalWorkerSettings": DigitalWorkerSettings.from_dict(obj["digitalWorkerSettings"]) if obj.get("digitalWorkerSettings") is not None else None,
            "financialPreferences": FinancialPreferences.from_dict(obj["financialPreferences"]) if obj.get("financialPreferences") is not None else None
        })
        return _obj


