# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class RoleType(str, Enum):
    """
    Roles available within a team, defining the level of access and responsibilities.   - ROLE_TYPE_UNSPECIFIED: Default unspecified role.  - ROLE_TYPE_OWNER: Owner with the highest permissions.  - ROLE_TYPE_ADMIN: Admin with managerial permissions.  - ROLE_TYPE_MEMBER: Member with standard access.  - ROLE_TYPE_GUEST: Guest with limited access.  - ROLE_TYPE_SUPER_ADMIN: Super Admin with overarching control.  - ROLE_TYPE_TEAM_ADMIN: Team Admin specific to team-level management.  - ROLE_TYPE_REGULAR: Regular team member.  - ROLE_TYPE_MANAGER: Team manager  - ROLE_TYPE_VIEWER: Read-only team member
    """

    """
    allowed enum values
    """
    ROLE_TYPE_UNSPECIFIED = 'ROLE_TYPE_UNSPECIFIED'
    ROLE_TYPE_OWNER = 'ROLE_TYPE_OWNER'
    ROLE_TYPE_ADMIN = 'ROLE_TYPE_ADMIN'
    ROLE_TYPE_MEMBER = 'ROLE_TYPE_MEMBER'
    ROLE_TYPE_GUEST = 'ROLE_TYPE_GUEST'
    ROLE_TYPE_SUPER_ADMIN = 'ROLE_TYPE_SUPER_ADMIN'
    ROLE_TYPE_TEAM_ADMIN = 'ROLE_TYPE_TEAM_ADMIN'
    ROLE_TYPE_REGULAR = 'ROLE_TYPE_REGULAR'
    ROLE_TYPE_MANAGER = 'ROLE_TYPE_MANAGER'
    ROLE_TYPE_VIEWER = 'ROLE_TYPE_VIEWER'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of RoleType from a JSON string"""
        return cls(json.loads(json_str))


