# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.personal_actionable_insight_name import PersonalActionableInsightName
from typing import Optional, Set
from typing_extensions import Self

class PersonalActionableInsight(BaseModel):
    """
    PersonalActionableInsight
    """ # noqa: E501
    id: Optional[StrictStr] = None
    insight_name: Optional[PersonalActionableInsightName] = Field(default=PersonalActionableInsightName.UNSPECIFIED, alias="insightName")
    description: Optional[StrictStr] = None
    takeaway: Optional[StrictStr] = None
    action: Optional[StrictStr] = None
    expected_benefit: Optional[StrictStr] = Field(default=None, alias="expectedBenefit")
    tags: Optional[List[StrictStr]] = None
    generated_time: Optional[datetime] = Field(default=None, alias="generatedTime")
    metrics_to_optimize_for: Optional[List[StrictStr]] = Field(default=None, alias="metricsToOptimizeFor")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "insightName", "description", "takeaway", "action", "expectedBenefit", "tags", "generatedTime", "metricsToOptimizeFor", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PersonalActionableInsight from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PersonalActionableInsight from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "insightName": obj.get("insightName") if obj.get("insightName") is not None else PersonalActionableInsightName.UNSPECIFIED,
            "description": obj.get("description"),
            "takeaway": obj.get("takeaway"),
            "action": obj.get("action"),
            "expectedBenefit": obj.get("expectedBenefit"),
            "tags": obj.get("tags"),
            "generatedTime": obj.get("generatedTime"),
            "metricsToOptimizeFor": obj.get("metricsToOptimizeFor"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


