# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from solomonai_backend_client_sdk.models.address import Address
from solomonai_backend_client_sdk.models.audit_log import AuditLog
from solomonai_backend_client_sdk.models.compliance_tier import ComplianceTier
from solomonai_backend_client_sdk.models.industry_type import IndustryType
from solomonai_backend_client_sdk.models.org_api_key import OrgAPIKey
from solomonai_backend_client_sdk.models.org_member import OrgMember
from solomonai_backend_client_sdk.models.org_usage_log import OrgUsageLog
from solomonai_backend_client_sdk.models.regulatory_status import RegulatoryStatus
from solomonai_backend_client_sdk.models.subscription_status import SubscriptionStatus
from solomonai_backend_client_sdk.models.subscription_tier import SubscriptionTier
from typing import Optional, Set
from typing_extensions import Self

class Organization(BaseModel):
    """
    Organization
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the organization (UUID format).")
    name: Optional[StrictStr] = Field(default=None, description="Legal name of the organization.")
    display_name: Optional[StrictStr] = Field(default=None, description="Display name of the organization for UI purposes.", alias="displayName")
    domain: Optional[StrictStr] = Field(default=None, description="Official domain associated with the organization (e.g., \"example.com\").")
    subscription_tier: Optional[SubscriptionTier] = Field(default=SubscriptionTier.UNSPECIFIED, alias="subscriptionTier")
    subscription_status: Optional[SubscriptionStatus] = Field(default=SubscriptionStatus.UNSPECIFIED, alias="subscriptionStatus")
    email: Optional[StrictStr] = Field(default=None, description="Primary contact email for the organization.")
    created_at: Optional[datetime] = Field(default=None, description="Timestamp for when the organization was created.", alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, description="Timestamp for when the organization was last updated.", alias="updatedAt")
    is_active: Optional[StrictBool] = Field(default=None, description="Indicates if the organization is active.", alias="isActive")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="Flexible metadata in structured format for additional data storage.")
    max_users: Optional[StrictStr] = Field(default=None, description="Maximum number of users allowed for the organization.", alias="maxUsers")
    technical_contact: Optional[StrictStr] = Field(default=None, description="Technical contact email for support or administrative purposes.", alias="technicalContact")
    owner_supabase_auth_user_id: Optional[StrictStr] = Field(default=None, description="User ID of the owner or administrator associated with the organization.", alias="ownerSupabaseAuthUserId")
    storage_quota: Optional[StrictStr] = Field(default=None, description="Storage quota for the organization in bytes.", alias="storageQuota")
    used_storage: Optional[StrictStr] = Field(default=None, description="Amount of storage currently used by the organization in bytes.", alias="usedStorage")
    max_workspaces: Optional[StrictInt] = Field(default=None, description="Maximum number of workspaces allowed for the organization.", alias="maxWorkspaces")
    max_members: Optional[StrictInt] = Field(default=None, description="Maximum number of members allowed in the organization.", alias="maxMembers")
    api_key_prefix: Optional[StrictStr] = Field(default=None, description="Prefix for API keys issued by the organization, used for key identification.", alias="apiKeyPrefix")
    security_settings: Optional[Dict[str, Any]] = Field(default=None, description="Security settings in structured format, providing flexibility for custom security configurations.", alias="securitySettings")
    feature_flags: Optional[Dict[str, Any]] = Field(default=None, description="Feature flags in structured format, enabling or disabling specific features.", alias="featureFlags")
    industry: Optional[IndustryType] = IndustryType.UNSPECIFIED
    phone_number: Optional[StrictStr] = Field(default=None, description="Phone number for the organization (international format).", alias="phoneNumber")
    website_url: Optional[StrictStr] = Field(default=None, description="Website URL of the organization.", alias="websiteUrl")
    address: Optional[Address] = None
    compliance_requirements: Optional[List[StrictStr]] = Field(default=None, description="Compliance requirements for the organization, stored as a list of strings.", alias="complianceRequirements")
    deleted_at: Optional[datetime] = Field(default=None, description="Timestamp for when the organization was soft-deleted.", alias="deletedAt")
    tenants: Optional[List[Tenant]] = None
    org_members: Optional[List[OrgMember]] = Field(default=None, description="List of members within the organization.", alias="orgMembers")
    org_api_keys: Optional[List[OrgAPIKey]] = Field(default=None, description="API keys issued by the organization.", alias="orgApiKeys")
    org_usage_logs: Optional[List[OrgUsageLog]] = Field(default=None, description="Usage logs related to the organization, for tracking resource consumption.", alias="orgUsageLogs")
    audit_logs: Optional[List[AuditLog]] = Field(default=None, description="Audit logs for tracking organizational events, changes, and security.", alias="auditLogs")
    record_id_reference: Optional[StrictStr] = Field(default=None, alias="recordIdReference")
    regulatory_status: Optional[RegulatoryStatus] = Field(default=RegulatoryStatus.UNSPECIFIED, alias="regulatoryStatus")
    license_numbers: Optional[List[StrictStr]] = Field(default=None, alias="licenseNumbers")
    compliance_tier: Optional[ComplianceTier] = Field(default=ComplianceTier.UNSPECIFIED, alias="complianceTier")
    kyc_provider: Optional[StrictStr] = Field(default=None, alias="kycProvider")
    payment_provider: Optional[StrictStr] = Field(default=None, alias="paymentProvider")
    transaction_limit: Optional[StrictStr] = Field(default=None, alias="transactionLimit")
    risk_score: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="riskScore")
    __properties: ClassVar[List[str]] = ["id", "name", "displayName", "domain", "subscriptionTier", "subscriptionStatus", "email", "createdAt", "updatedAt", "isActive", "metadata", "maxUsers", "technicalContact", "ownerSupabaseAuthUserId", "storageQuota", "usedStorage", "maxWorkspaces", "maxMembers", "apiKeyPrefix", "securitySettings", "featureFlags", "industry", "phoneNumber", "websiteUrl", "address", "complianceRequirements", "deletedAt", "tenants", "orgMembers", "orgApiKeys", "orgUsageLogs", "auditLogs", "recordIdReference", "regulatoryStatus", "licenseNumbers", "complianceTier", "kycProvider", "paymentProvider", "transactionLimit", "riskScore"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Organization from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tenants (list)
        _items = []
        if self.tenants:
            for _item in self.tenants:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tenants'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in org_members (list)
        _items = []
        if self.org_members:
            for _item in self.org_members:
                if _item:
                    _items.append(_item.to_dict())
            _dict['orgMembers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in org_api_keys (list)
        _items = []
        if self.org_api_keys:
            for _item in self.org_api_keys:
                if _item:
                    _items.append(_item.to_dict())
            _dict['orgApiKeys'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in org_usage_logs (list)
        _items = []
        if self.org_usage_logs:
            for _item in self.org_usage_logs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['orgUsageLogs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in audit_logs (list)
        _items = []
        if self.audit_logs:
            for _item in self.audit_logs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['auditLogs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Organization from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "displayName": obj.get("displayName"),
            "domain": obj.get("domain"),
            "subscriptionTier": obj.get("subscriptionTier") if obj.get("subscriptionTier") is not None else SubscriptionTier.UNSPECIFIED,
            "subscriptionStatus": obj.get("subscriptionStatus") if obj.get("subscriptionStatus") is not None else SubscriptionStatus.UNSPECIFIED,
            "email": obj.get("email"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "isActive": obj.get("isActive"),
            "metadata": obj.get("metadata"),
            "maxUsers": obj.get("maxUsers"),
            "technicalContact": obj.get("technicalContact"),
            "ownerSupabaseAuthUserId": obj.get("ownerSupabaseAuthUserId"),
            "storageQuota": obj.get("storageQuota"),
            "usedStorage": obj.get("usedStorage"),
            "maxWorkspaces": obj.get("maxWorkspaces"),
            "maxMembers": obj.get("maxMembers"),
            "apiKeyPrefix": obj.get("apiKeyPrefix"),
            "securitySettings": obj.get("securitySettings"),
            "featureFlags": obj.get("featureFlags"),
            "industry": obj.get("industry") if obj.get("industry") is not None else IndustryType.UNSPECIFIED,
            "phoneNumber": obj.get("phoneNumber"),
            "websiteUrl": obj.get("websiteUrl"),
            "address": Address.from_dict(obj["address"]) if obj.get("address") is not None else None,
            "complianceRequirements": obj.get("complianceRequirements"),
            "deletedAt": obj.get("deletedAt"),
            "tenants": [Tenant.from_dict(_item) for _item in obj["tenants"]] if obj.get("tenants") is not None else None,
            "orgMembers": [OrgMember.from_dict(_item) for _item in obj["orgMembers"]] if obj.get("orgMembers") is not None else None,
            "orgApiKeys": [OrgAPIKey.from_dict(_item) for _item in obj["orgApiKeys"]] if obj.get("orgApiKeys") is not None else None,
            "orgUsageLogs": [OrgUsageLog.from_dict(_item) for _item in obj["orgUsageLogs"]] if obj.get("orgUsageLogs") is not None else None,
            "auditLogs": [AuditLog.from_dict(_item) for _item in obj["auditLogs"]] if obj.get("auditLogs") is not None else None,
            "recordIdReference": obj.get("recordIdReference"),
            "regulatoryStatus": obj.get("regulatoryStatus") if obj.get("regulatoryStatus") is not None else RegulatoryStatus.UNSPECIFIED,
            "licenseNumbers": obj.get("licenseNumbers"),
            "complianceTier": obj.get("complianceTier") if obj.get("complianceTier") is not None else ComplianceTier.UNSPECIFIED,
            "kycProvider": obj.get("kycProvider"),
            "paymentProvider": obj.get("paymentProvider"),
            "transactionLimit": obj.get("transactionLimit"),
            "riskScore": obj.get("riskScore")
        })
        return _obj

from solomonai_backend_client_sdk.models.tenant import Tenant
# TODO: Rewrite to not use raise_errors
Organization.model_rebuild(raise_errors=False)

