# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.api_key_environment import APIKeyEnvironment
from solomonai_backend_client_sdk.models.api_permission import ApiPermission
from solomonai_backend_client_sdk.models.scope_type import ScopeType
from typing import Optional, Set
from typing_extensions import Self

class OrgAPIKey(BaseModel):
    """
    OrgAPIKey
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the API key.")
    key_name: StrictStr = Field(description="Name of the API key.", alias="keyName")
    description: Optional[StrictStr] = Field(default=None, description="Description of the API key.")
    key_id: StrictStr = Field(description="Unique key identifier.", alias="keyId")
    key_hash: Optional[StrictStr] = Field(default=None, description="Hashed API key.", alias="keyHash")
    scopes: Optional[List[ScopeType]] = Field(default=None, description="Scopes assigned to the API key.")
    rate_limit: Optional[StrictInt] = Field(default=None, description="Rate limit for the API key.", alias="rateLimit")
    allowed_ips: Optional[List[StrictStr]] = Field(default=None, description="Allowed IP addresses (supports both IPv4 and IPv6 with CIDR notation).", alias="allowedIps")
    allowed_domains: Optional[List[StrictStr]] = Field(default=None, description="Allowed domains.", alias="allowedDomains")
    usage_count: Optional[StrictInt] = Field(default=None, description="Usage count of the API key.", alias="usageCount")
    max_usage_count: Optional[StrictInt] = Field(default=None, description="Maximum usage count allowed.", alias="maxUsageCount")
    last_used_ip: Optional[StrictStr] = Field(default=None, description="Last used IP address.", alias="lastUsedIp")
    environment: Optional[APIKeyEnvironment] = APIKeyEnvironment.UNSPECIFIED
    revoked: Optional[StrictBool] = Field(default=None, description="Indicates if the key has been revoked.")
    revoked_at: Optional[datetime] = Field(default=None, description="Timestamp when the key was revoked.", alias="revokedAt")
    revoked_reason: Optional[StrictStr] = Field(default=None, description="Reason for revocation.", alias="revokedReason")
    expires_at: Optional[datetime] = Field(default=None, description="Expiration date of the key.", alias="expiresAt")
    created_at: Optional[datetime] = Field(default=None, description="Timestamp when the key was created.", alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, description="Timestamp when the key was last updated.", alias="updatedAt")
    created_by: Optional[StrictStr] = Field(default=None, description="ID of the creator.", alias="createdBy")
    last_used: Optional[datetime] = Field(default=None, description="Timestamp when the key was last used.", alias="lastUsed")
    is_active: Optional[StrictBool] = Field(default=None, description="Indicates if the key is active.", alias="isActive")
    permissions: Optional[List[ApiPermission]] = None
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "keyName", "description", "keyId", "keyHash", "scopes", "rateLimit", "allowedIps", "allowedDomains", "usageCount", "maxUsageCount", "lastUsedIp", "environment", "revoked", "revokedAt", "revokedReason", "expiresAt", "createdAt", "updatedAt", "createdBy", "lastUsed", "isActive", "permissions", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrgAPIKey from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in permissions (list)
        _items = []
        if self.permissions:
            for _item in self.permissions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['permissions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrgAPIKey from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "keyName": obj.get("keyName"),
            "description": obj.get("description"),
            "keyId": obj.get("keyId"),
            "keyHash": obj.get("keyHash"),
            "scopes": obj.get("scopes"),
            "rateLimit": obj.get("rateLimit"),
            "allowedIps": obj.get("allowedIps"),
            "allowedDomains": obj.get("allowedDomains"),
            "usageCount": obj.get("usageCount"),
            "maxUsageCount": obj.get("maxUsageCount"),
            "lastUsedIp": obj.get("lastUsedIp"),
            "environment": obj.get("environment") if obj.get("environment") is not None else APIKeyEnvironment.UNSPECIFIED,
            "revoked": obj.get("revoked"),
            "revokedAt": obj.get("revokedAt"),
            "revokedReason": obj.get("revokedReason"),
            "expiresAt": obj.get("expiresAt"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "createdBy": obj.get("createdBy"),
            "lastUsed": obj.get("lastUsed"),
            "isActive": obj.get("isActive"),
            "permissions": [ApiPermission.from_dict(_item) for _item in obj["permissions"]] if obj.get("permissions") is not None else None,
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


