# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.workspace_activity import WorkspaceActivity
from typing import Optional, Set
from typing_extensions import Self

class ListWorkspaceActivityResponse(BaseModel):
    """
    ListWorkspaceActivityResponse contains the paginated list of workspace activities and associated statistics.  The response includes: - List of activity records - Pagination info for fetching next page - Activity statistics broken down by type and user  Example: ```protobuf message response {   activities: [     {activity_1_details},     {activity_2_details}   ]   next_page_number: 2   activity_type_counts: {     \"file_upload\": 10,     \"comment_added\": 5   }   user_activity_counts: {     \"user123\": 8,     \"user456\": 7   } } ```
    """ # noqa: E501
    activities: Optional[List[WorkspaceActivity]] = None
    next_page_number: Optional[StrictStr] = Field(default=None, alias="nextPageNumber")
    activity_type_counts: Optional[Dict[str, StrictInt]] = Field(default=None, alias="activityTypeCounts")
    user_activity_counts: Optional[Dict[str, StrictInt]] = Field(default=None, alias="userActivityCounts")
    __properties: ClassVar[List[str]] = ["activities", "nextPageNumber", "activityTypeCounts", "userActivityCounts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListWorkspaceActivityResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in activities (list)
        _items = []
        if self.activities:
            for _item in self.activities:
                if _item:
                    _items.append(_item.to_dict())
            _dict['activities'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListWorkspaceActivityResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "activities": [WorkspaceActivity.from_dict(_item) for _item in obj["activities"]] if obj.get("activities") is not None else None,
            "nextPageNumber": obj.get("nextPageNumber"),
            "activityTypeCounts": obj.get("activityTypeCounts"),
            "userActivityCounts": obj.get("userActivityCounts")
        })
        return _obj


