# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class Item(BaseModel):
    """
    The Item object refers to the goods involved in a transaction.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    remote_id: Optional[StrictStr] = Field(default=None, description="The third-party API ID of the matching object.", alias="remoteId")
    name: Optional[StrictStr] = Field(default=None, description="The item's name.")
    status: Optional[StrictStr] = None
    unit_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The item's unit price.", alias="unitPrice")
    purchase_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The price at which the item is purchased from a vendor.", alias="purchasePrice")
    purchase_account: Optional[StrictStr] = Field(default=None, description="References the default account used to record a purchase of the item.", alias="purchaseAccount")
    sales_account: Optional[StrictStr] = Field(default=None, description="References the default account used to record a sale.", alias="salesAccount")
    company: Optional[StrictStr] = Field(default=None, description="The company the item belongs to.")
    remote_updated_at: Optional[datetime] = Field(default=None, description="When the third party's item note was updated.", alias="remoteUpdatedAt")
    remote_was_deleted: Optional[StrictBool] = Field(default=None, description="Indicates whether or not this object has been deleted by third party webhooks.", alias="remoteWasDeleted")
    modified_at: Optional[datetime] = Field(default=None, alias="modifiedAt")
    merge_record_id: Optional[StrictStr] = Field(default=None, alias="mergeRecordId")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "remoteId", "name", "status", "unitPrice", "purchasePrice", "purchaseAccount", "salesAccount", "company", "remoteUpdatedAt", "remoteWasDeleted", "modifiedAt", "mergeRecordId", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Item from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Item from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "remoteId": obj.get("remoteId"),
            "name": obj.get("name"),
            "status": obj.get("status"),
            "unitPrice": obj.get("unitPrice"),
            "purchasePrice": obj.get("purchasePrice"),
            "purchaseAccount": obj.get("purchaseAccount"),
            "salesAccount": obj.get("salesAccount"),
            "company": obj.get("company"),
            "remoteUpdatedAt": obj.get("remoteUpdatedAt"),
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "modifiedAt": obj.get("modifiedAt"),
            "mergeRecordId": obj.get("mergeRecordId"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


