# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class InvestmentSecurity(BaseModel):
    """
    InvestmentSecurity
    """ # noqa: E501
    id: Optional[StrictStr] = None
    close_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="closePrice")
    close_price_as_of: Optional[StrictStr] = Field(default=None, alias="closePriceAsOf")
    cusip: Optional[StrictStr] = None
    institution_id: Optional[StrictStr] = Field(default=None, alias="institutionId")
    institution_security_id: Optional[StrictStr] = Field(default=None, alias="institutionSecurityId")
    is_cash_equivalent: Optional[StrictBool] = Field(default=None, alias="isCashEquivalent")
    isin: Optional[StrictStr] = None
    iso_currency_code: Optional[StrictStr] = Field(default=None, alias="isoCurrencyCode")
    name: Optional[StrictStr] = None
    proxy_security_id: Optional[StrictStr] = Field(default=None, alias="proxySecurityId")
    security_id: Optional[StrictStr] = Field(default=None, alias="securityId")
    sedol: Optional[StrictStr] = None
    ticker_symbol: Optional[StrictStr] = Field(default=None, alias="tickerSymbol")
    type: Optional[StrictStr] = None
    unofficial_currency_code: Optional[StrictStr] = Field(default=None, alias="unofficialCurrencyCode")
    update_datetime: Optional[StrictStr] = Field(default=None, alias="updateDatetime")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "closePrice", "closePriceAsOf", "cusip", "institutionId", "institutionSecurityId", "isCashEquivalent", "isin", "isoCurrencyCode", "name", "proxySecurityId", "securityId", "sedol", "tickerSymbol", "type", "unofficialCurrencyCode", "updateDatetime", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InvestmentSecurity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InvestmentSecurity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "closePrice": obj.get("closePrice"),
            "closePriceAsOf": obj.get("closePriceAsOf"),
            "cusip": obj.get("cusip"),
            "institutionId": obj.get("institutionId"),
            "institutionSecurityId": obj.get("institutionSecurityId"),
            "isCashEquivalent": obj.get("isCashEquivalent"),
            "isin": obj.get("isin"),
            "isoCurrencyCode": obj.get("isoCurrencyCode"),
            "name": obj.get("name"),
            "proxySecurityId": obj.get("proxySecurityId"),
            "securityId": obj.get("securityId"),
            "sedol": obj.get("sedol"),
            "tickerSymbol": obj.get("tickerSymbol"),
            "type": obj.get("type"),
            "unofficialCurrencyCode": obj.get("unofficialCurrencyCode"),
            "updateDatetime": obj.get("updateDatetime"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


