# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.company_profile import CompanyProfile
from solomonai_backend_client_sdk.models.employee import Employee
from solomonai_backend_client_sdk.models.employer_benefits import EmployerBenefits
from solomonai_backend_client_sdk.models.employer_payroll_run import EmployerPayrollRun
from typing import Optional, Set
from typing_extensions import Self

class HrisLinkedAccount(BaseModel):
    """
    HrisLinkedAccount
    """ # noqa: E501
    id: Optional[StrictStr] = None
    profile: Optional[CompanyProfile] = None
    benefit_plans: Optional[List[EmployerBenefits]] = Field(default=None, alias="benefitPlans")
    employees: Optional[List[Employee]] = None
    payroll_runs: Optional[List[EmployerPayrollRun]] = Field(default=None, alias="payrollRuns")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "profile", "benefitPlans", "employees", "payrollRuns", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HrisLinkedAccount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of profile
        if self.profile:
            _dict['profile'] = self.profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in benefit_plans (list)
        _items = []
        if self.benefit_plans:
            for _item in self.benefit_plans:
                if _item:
                    _items.append(_item.to_dict())
            _dict['benefitPlans'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in employees (list)
        _items = []
        if self.employees:
            for _item in self.employees:
                if _item:
                    _items.append(_item.to_dict())
            _dict['employees'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payroll_runs (list)
        _items = []
        if self.payroll_runs:
            for _item in self.payroll_runs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['payrollRuns'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HrisLinkedAccount from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "profile": CompanyProfile.from_dict(obj["profile"]) if obj.get("profile") is not None else None,
            "benefitPlans": [EmployerBenefits.from_dict(_item) for _item in obj["benefitPlans"]] if obj.get("benefitPlans") is not None else None,
            "employees": [Employee.from_dict(_item) for _item in obj["employees"]] if obj.get("employees") is not None else None,
            "payrollRuns": [EmployerPayrollRun.from_dict(_item) for _item in obj["payrollRuns"]] if obj.get("payrollRuns") is not None else None,
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


