# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.total_investment_by_security import TotalInvestmentBySecurity
from typing import Optional, Set
from typing_extensions import Self

class GetTotalInvestmentBySecurityResponse(BaseModel):
    """
    GetTotalInvestmentBySecurityResponse
    """ # noqa: E501
    total_investment_by_security: Optional[List[TotalInvestmentBySecurity]] = Field(default=None, alias="totalInvestmentBySecurity")
    next_page_number: Optional[StrictStr] = Field(default=None, alias="nextPageNumber")
    __properties: ClassVar[List[str]] = ["totalInvestmentBySecurity", "nextPageNumber"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetTotalInvestmentBySecurityResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in total_investment_by_security (list)
        _items = []
        if self.total_investment_by_security:
            for _item in self.total_investment_by_security:
                if _item:
                    _items.append(_item.to_dict())
            _dict['totalInvestmentBySecurity'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetTotalInvestmentBySecurityResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "totalInvestmentBySecurity": [TotalInvestmentBySecurity.from_dict(_item) for _item in obj["totalInvestmentBySecurity"]] if obj.get("totalInvestmentBySecurity") is not None else None,
            "nextPageNumber": obj.get("nextPageNumber")
        })
        return _obj


