# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class GetMergeLinkTokenResponse(BaseModel):
    """
    Defines a message named GetLinkTokenResponse.
    """ # noqa: E501
    link_token: Optional[StrictStr] = Field(default=None, description="A string field named \"link_token\" with field number 1.", alias="linkToken")
    integration_name: Optional[StrictStr] = Field(default=None, description="A string field named \"integration_name\" with field number 2.", alias="integrationName")
    magic_link_url: Optional[StrictStr] = Field(default=None, description="A string field named \"magic_link_url\" with field number 3.", alias="magicLinkUrl")
    end_user_origin_id: Optional[StrictStr] = Field(default=None, description="A string field named \"end_user_origin_id\" with field number 4.", alias="endUserOriginId")
    organization_name: Optional[StrictStr] = Field(default=None, description="A string field named \"organization_name\" with field number 5.", alias="organizationName")
    __properties: ClassVar[List[str]] = ["linkToken", "integrationName", "magicLinkUrl", "endUserOriginId", "organizationName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetMergeLinkTokenResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetMergeLinkTokenResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "linkToken": obj.get("linkToken"),
            "integrationName": obj.get("integrationName"),
            "magicLinkUrl": obj.get("magicLinkUrl"),
            "endUserOriginId": obj.get("endUserOriginId"),
            "organizationName": obj.get("organizationName")
        })
        return _obj


