# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.file_metadata import FileMetadata
from typing import Optional, Set
from typing_extensions import Self

class FolderMetadata(BaseModel):
    """
    FolderMetadata represents a directory structure within a workspace. Supports hierarchical organization of files and nested folders.  Key features: - Hierarchical structure - S3 path mapping - File collection management - Version control - Soft deletion  Usage example: ```go folder := &FolderMetadata{   Name: \"Documents\",   S3FolderPath: \"/user-123/documents/\",   IsDeleted: false } ```
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    child_folder: Optional[List[FolderMetadata]] = Field(default=None, alias="childFolder")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    files: Optional[List[FileMetadata]] = None
    is_deleted: Optional[StrictBool] = Field(default=None, alias="isDeleted")
    s3_bucket_name: Optional[StrictStr] = Field(default=None, description="The S3 bucket name where the folder is located.", alias="s3BucketName")
    s3_folder_path: Optional[StrictStr] = Field(default=None, description="The prefix path representing the folder in the S3 bucket.", alias="s3FolderPath")
    s3_region: Optional[StrictStr] = Field(default=None, description="AWS region where the S3 bucket containing the folder is located.", alias="s3Region")
    s3_metadata: Optional[Dict[str, StrictStr]] = Field(default=None, description="Custom metadata for the folder, represented as key-value pairs.", alias="s3Metadata")
    s3_acl: Optional[StrictStr] = Field(default=None, description="Access control list (ACL) permissions for the folder in S3.", alias="s3Acl")
    s3_last_modified: Optional[datetime] = Field(default=None, description="The date and time when the folder was last modified in S3. This might represent the last time a file was added, removed, or changed in the folder.", alias="s3LastModified")
    version_id: Optional[StrictStr] = Field(default=None, alias="versionId")
    description: Optional[StrictStr] = Field(default=None, description="Folder description")
    metadata_json: Optional[StrictStr] = Field(default=None, alias="metadataJson")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "name", "childFolder", "createdAt", "updatedAt", "files", "isDeleted", "s3BucketName", "s3FolderPath", "s3Region", "s3Metadata", "s3Acl", "s3LastModified", "versionId", "description", "metadataJson", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FolderMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in child_folder (list)
        _items = []
        if self.child_folder:
            for _item in self.child_folder:
                if _item:
                    _items.append(_item.to_dict())
            _dict['childFolder'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in files (list)
        _items = []
        if self.files:
            for _item in self.files:
                if _item:
                    _items.append(_item.to_dict())
            _dict['files'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FolderMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "childFolder": [FolderMetadata.from_dict(_item) for _item in obj["childFolder"]] if obj.get("childFolder") is not None else None,
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "files": [FileMetadata.from_dict(_item) for _item in obj["files"]] if obj.get("files") is not None else None,
            "isDeleted": obj.get("isDeleted"),
            "s3BucketName": obj.get("s3BucketName"),
            "s3FolderPath": obj.get("s3FolderPath"),
            "s3Region": obj.get("s3Region"),
            "s3Metadata": obj.get("s3Metadata"),
            "s3Acl": obj.get("s3Acl"),
            "s3LastModified": obj.get("s3LastModified"),
            "versionId": obj.get("versionId"),
            "description": obj.get("description"),
            "metadataJson": obj.get("metadataJson"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj

# TODO: Rewrite to not use raise_errors
FolderMetadata.model_rebuild(raise_errors=False)

