# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.document_snapshot import DocumentSnapshot
from typing import Optional, Set
from typing_extensions import Self

class FileVersions(BaseModel):
    """
    FileVersions manages version history for files. Tracks changes and maintains version lineage.  Features: - Sequential versioning - Change tracking - Size history - Modification attribution
    """ # noqa: E501
    id: Optional[StrictStr] = None
    file_id: Optional[StrictStr] = Field(default=None, alias="fileId")
    version_number: Optional[StrictInt] = Field(default=None, alias="versionNumber")
    s3_version_id: Optional[StrictStr] = Field(default=None, alias="s3VersionId")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    size: Optional[StrictStr] = None
    checksum: Optional[StrictStr] = None
    modified_by: Optional[StrictStr] = Field(default=None, alias="modifiedBy")
    change_summary: Optional[StrictStr] = Field(default=None, alias="changeSummary")
    snapshot: Optional[DocumentSnapshot] = None
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    __properties: ClassVar[List[str]] = ["id", "fileId", "versionNumber", "s3VersionId", "createdAt", "size", "checksum", "modifiedBy", "changeSummary", "snapshot", "deletedAt", "updatedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FileVersions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of snapshot
        if self.snapshot:
            _dict['snapshot'] = self.snapshot.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FileVersions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "fileId": obj.get("fileId"),
            "versionNumber": obj.get("versionNumber"),
            "s3VersionId": obj.get("s3VersionId"),
            "createdAt": obj.get("createdAt"),
            "size": obj.get("size"),
            "checksum": obj.get("checksum"),
            "modifiedBy": obj.get("modifiedBy"),
            "changeSummary": obj.get("changeSummary"),
            "snapshot": DocumentSnapshot.from_dict(obj["snapshot"]) if obj.get("snapshot") is not None else None,
            "deletedAt": obj.get("deletedAt"),
            "updatedAt": obj.get("updatedAt")
        })
        return _obj


