# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.share_permission import SharePermission
from typing import Optional, Set
from typing_extensions import Self

class FileSharing(BaseModel):
    """
    FileSharing manages link sharing for files.  Features: - Secure link generation - Access permissions - Expiration settings - Access tracking
    """ # noqa: E501
    id: Optional[StrictStr] = None
    file_id: Optional[StrictStr] = Field(default=None, alias="fileId")
    shared_link: Optional[StrictStr] = Field(default=None, alias="sharedLink")
    permission_level: Optional[SharePermission] = Field(default=SharePermission.UNSPECIFIED, alias="permissionLevel")
    expires_at: Optional[datetime] = Field(default=None, alias="expiresAt")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    last_accessed: Optional[datetime] = Field(default=None, alias="lastAccessed")
    is_active: Optional[StrictBool] = Field(default=None, alias="isActive")
    password: Optional[StrictStr] = None
    max_accesses: Optional[StrictInt] = Field(default=None, alias="maxAccesses")
    access_count: Optional[StrictInt] = Field(default=None, alias="accessCount")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "fileId", "sharedLink", "permissionLevel", "expiresAt", "createdAt", "lastAccessed", "isActive", "password", "maxAccesses", "accessCount", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FileSharing from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FileSharing from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "fileId": obj.get("fileId"),
            "sharedLink": obj.get("sharedLink"),
            "permissionLevel": obj.get("permissionLevel") if obj.get("permissionLevel") is not None else SharePermission.UNSPECIFIED,
            "expiresAt": obj.get("expiresAt"),
            "createdAt": obj.get("createdAt"),
            "lastAccessed": obj.get("lastAccessed"),
            "isActive": obj.get("isActive"),
            "password": obj.get("password"),
            "maxAccesses": obj.get("maxAccesses"),
            "accessCount": obj.get("accessCount"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


