# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.benefit_plan_type import BenefitPlanType
from solomonai_backend_client_sdk.models.employee_benefits import EmployeeBenefits
from typing import Optional, Set
from typing_extensions import Self

class EmployerBenefits(BaseModel):
    """
    EmployerBenefits is used to represent a benefit plan offered by a company.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    remote_id: Optional[StrictStr] = Field(default=None, description="The third-party API ID of the matching object.  External system identifier (integration)", alias="remoteId")
    benefit_plan_type: Optional[BenefitPlanType] = Field(default=BenefitPlanType.UNSPECIFIED, alias="benefitPlanType")
    name: Optional[StrictStr] = Field(default=None, description="The employer benefit's name - typically the carrier or network name.  Name of the benefit plan")
    description: Optional[StrictStr] = Field(default=None, description="The employer benefit's description.  Description of the plan")
    deduction_code: Optional[StrictStr] = Field(default=None, description="The employer benefit's deduction code.  Code for payroll deduction", alias="deductionCode")
    remote_was_deleted: Optional[datetime] = Field(default=None, description="Indicates whether or not this object has been deleted in the third party platform.  Flag for deletion status", alias="remoteWasDeleted")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    modified_at: Optional[datetime] = Field(default=None, description="Last modification date in ISO 8601 format", alias="modifiedAt")
    merge_account_id: Optional[StrictStr] = Field(default=None, description="Merge record UUID", alias="mergeAccountId")
    employee_benefits: Optional[List[EmployeeBenefits]] = Field(default=None, alias="employeeBenefits")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "remoteId", "benefitPlanType", "name", "description", "deductionCode", "remoteWasDeleted", "createdAt", "modifiedAt", "mergeAccountId", "employeeBenefits", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmployerBenefits from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in employee_benefits (list)
        _items = []
        if self.employee_benefits:
            for _item in self.employee_benefits:
                if _item:
                    _items.append(_item.to_dict())
            _dict['employeeBenefits'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmployerBenefits from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "remoteId": obj.get("remoteId"),
            "benefitPlanType": obj.get("benefitPlanType") if obj.get("benefitPlanType") is not None else BenefitPlanType.UNSPECIFIED,
            "name": obj.get("name"),
            "description": obj.get("description"),
            "deductionCode": obj.get("deductionCode"),
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "createdAt": obj.get("createdAt"),
            "modifiedAt": obj.get("modifiedAt"),
            "mergeAccountId": obj.get("mergeAccountId"),
            "employeeBenefits": [EmployeeBenefits.from_dict(_item) for _item in obj["employeeBenefits"]] if obj.get("employeeBenefits") is not None else None,
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


