# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from solomonai_backend_client_sdk.models.deduction import Deduction
from solomonai_backend_client_sdk.models.earning import Earning
from solomonai_backend_client_sdk.models.tax import Tax
from typing import Optional, Set
from typing_extensions import Self

class EmployeePayrollRun(BaseModel):
    """
    The EmployeePayrollRun object is used to represent an employee's pay statement for a specific payroll run.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    remote_id: Optional[StrictStr] = Field(default=None, description="The third-party API ID of the matching object.", alias="remoteId")
    gross_pay: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total earnings throughout a given period for an employee before any deductions are made.", alias="grossPay")
    net_pay: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The take-home pay throughout a given period for an employee after deductions are made.", alias="netPay")
    start_date: Optional[datetime] = Field(default=None, description="The day and time the payroll run started.", alias="startDate")
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    check_date: Optional[datetime] = Field(default=None, alias="checkDate")
    earnings: Optional[List[Earning]] = None
    deductions: Optional[List[Deduction]] = Field(default=None, description="The Deduction object is used to represent an array of the wages withheld from total earnings for the purpose of paying taxes.")
    taxes: Optional[List[Tax]] = Field(default=None, description="The Tax object is used to represent an array of the tax deductions for a given employee's payroll run.")
    remote_was_deleted: Optional[StrictBool] = Field(default=None, description="Indicates whether or not this object has been deleted in the third party platform.", alias="remoteWasDeleted")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    modified_at: Optional[datetime] = Field(default=None, alias="modifiedAt")
    payroll_run_merge_account_id: Optional[StrictStr] = Field(default=None, description="The payroll being run.", alias="payrollRunMergeAccountId")
    employee_merge_account_id: Optional[StrictStr] = Field(default=None, description="The employee whose payroll is being run.", alias="employeeMergeAccountId")
    merge_account_id: Optional[StrictStr] = Field(default=None, alias="mergeAccountId")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "remoteId", "grossPay", "netPay", "startDate", "endDate", "checkDate", "earnings", "deductions", "taxes", "remoteWasDeleted", "createdAt", "modifiedAt", "payrollRunMergeAccountId", "employeeMergeAccountId", "mergeAccountId", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmployeePayrollRun from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in earnings (list)
        _items = []
        if self.earnings:
            for _item in self.earnings:
                if _item:
                    _items.append(_item.to_dict())
            _dict['earnings'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in deductions (list)
        _items = []
        if self.deductions:
            for _item in self.deductions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['deductions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in taxes (list)
        _items = []
        if self.taxes:
            for _item in self.taxes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['taxes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmployeePayrollRun from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "remoteId": obj.get("remoteId"),
            "grossPay": obj.get("grossPay"),
            "netPay": obj.get("netPay"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "checkDate": obj.get("checkDate"),
            "earnings": [Earning.from_dict(_item) for _item in obj["earnings"]] if obj.get("earnings") is not None else None,
            "deductions": [Deduction.from_dict(_item) for _item in obj["deductions"]] if obj.get("deductions") is not None else None,
            "taxes": [Tax.from_dict(_item) for _item in obj["taxes"]] if obj.get("taxes") is not None else None,
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "createdAt": obj.get("createdAt"),
            "modifiedAt": obj.get("modifiedAt"),
            "payrollRunMergeAccountId": obj.get("payrollRunMergeAccountId"),
            "employeeMergeAccountId": obj.get("employeeMergeAccountId"),
            "mergeAccountId": obj.get("mergeAccountId"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


