# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.bank_info import BankInfo
from solomonai_backend_client_sdk.models.dependents import Dependents
from solomonai_backend_client_sdk.models.employe_time_off_balance import EmployeTimeOffBalance
from solomonai_backend_client_sdk.models.employee_benefits import EmployeeBenefits
from solomonai_backend_client_sdk.models.employee_job_position_at_company import EmployeeJobPositionAtCompany
from solomonai_backend_client_sdk.models.employee_payroll_run import EmployeePayrollRun
from solomonai_backend_client_sdk.models.employment_status import EmploymentStatus
from solomonai_backend_client_sdk.models.ethnicity import Ethnicity
from solomonai_backend_client_sdk.models.gender import Gender
from solomonai_backend_client_sdk.models.group import Group
from solomonai_backend_client_sdk.models.location_address import LocationAddress
from solomonai_backend_client_sdk.models.marital_status import MaritalStatus
from typing import Optional, Set
from typing_extensions import Self

class Employee(BaseModel):
    """
    The Employee object is used to represent any person who has been employed by a company.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    remote_id: Optional[StrictStr] = Field(default=None, description="The third-party API ID of the matching object.", alias="remoteId")
    employee_number: Optional[StrictStr] = Field(default=None, alias="employeeNumber")
    company_id: Optional[StrictStr] = Field(default=None, description="The ID of the employee's company.", alias="companyId")
    first_name: Optional[StrictStr] = Field(default=None, description="The employee's first name.", alias="firstName")
    last_name: Optional[StrictStr] = Field(default=None, description="The employee's last name.", alias="lastName")
    employees_preferred_name: Optional[StrictStr] = Field(default=None, description="The employee's preferred name.", alias="employeesPreferredName")
    display_full_name: Optional[StrictStr] = Field(default=None, alias="displayFullName")
    employee_user_name_as_seen_in_remote_ui: Optional[StrictStr] = Field(default=None, description="The employee's username that appears in the remote UI.", alias="employeeUserNameAsSeenInRemoteUi")
    work_email: Optional[StrictStr] = Field(default=None, description="The employee's work email.", alias="workEmail")
    personal_email: Optional[StrictStr] = Field(default=None, alias="personalEmail")
    mobile_phone_number: Optional[StrictStr] = Field(default=None, description="The employee's mobile phone number.", alias="mobilePhoneNumber")
    employments: Optional[List[EmployeeJobPositionAtCompany]] = None
    employment_type: Optional[StrictStr] = Field(default=None, description="UUID fields", alias="employmentType")
    home_location: Optional[LocationAddress] = Field(default=None, alias="homeLocation")
    work_location: Optional[LocationAddress] = Field(default=None, alias="workLocation")
    manager: Optional[Employee] = None
    group: Optional[Group] = None
    ssn: Optional[StrictStr] = None
    gender: Optional[Gender] = Gender.UNSPECIFIED
    ethnicity: Optional[Ethnicity] = Ethnicity.UNSPECIFIED
    marital_status: Optional[MaritalStatus] = Field(default=MaritalStatus.UNSPECIFIED, alias="maritalStatus")
    date_of_birth: Optional[StrictStr] = Field(default=None, description="The employee's date of birth.  Use string for ISO 8601 datetime", alias="dateOfBirth")
    start_date: Optional[datetime] = Field(default=None, description="The date that the employee started working. If an employee was rehired, the most recent start date will be returned.", alias="startDate")
    remote_created_at: Optional[datetime] = Field(default=None, description="When the third party's employee was created.", alias="remoteCreatedAt")
    employment_status: Optional[EmploymentStatus] = Field(default=EmploymentStatus.UNSPECIFIED, alias="employmentStatus")
    termination_date: Optional[datetime] = Field(default=None, description="The employee's termination date.", alias="terminationDate")
    avatar: Optional[StrictStr] = Field(default=None, description="The URL of the employee's avatar image.")
    bank_accounts: Optional[List[BankInfo]] = Field(default=None, alias="bankAccounts")
    dependents: Optional[List[Dependents]] = None
    payroll_runs: Optional[List[EmployeePayrollRun]] = Field(default=None, description="Represent an employee's pay statement for a specific payroll run.", alias="payrollRuns")
    pay_time_off_balance: Optional[EmployeTimeOffBalance] = Field(default=None, alias="payTimeOffBalance")
    benefits: Optional[List[EmployeeBenefits]] = Field(default=None, description="the benefits associated with the employee.")
    merge_account_id: Optional[StrictStr] = Field(default=None, alias="mergeAccountId")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    modified_at: Optional[datetime] = Field(default=None, alias="modifiedAt")
    remote_was_deleted: Optional[StrictBool] = Field(default=None, alias="remoteWasDeleted")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "remoteId", "employeeNumber", "companyId", "firstName", "lastName", "employeesPreferredName", "displayFullName", "employeeUserNameAsSeenInRemoteUi", "workEmail", "personalEmail", "mobilePhoneNumber", "employments", "employmentType", "homeLocation", "workLocation", "manager", "group", "ssn", "gender", "ethnicity", "maritalStatus", "dateOfBirth", "startDate", "remoteCreatedAt", "employmentStatus", "terminationDate", "avatar", "bankAccounts", "dependents", "payrollRuns", "payTimeOffBalance", "benefits", "mergeAccountId", "createdAt", "modifiedAt", "remoteWasDeleted", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Employee from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in employments (list)
        _items = []
        if self.employments:
            for _item in self.employments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['employments'] = _items
        # override the default output from pydantic by calling `to_dict()` of home_location
        if self.home_location:
            _dict['homeLocation'] = self.home_location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of work_location
        if self.work_location:
            _dict['workLocation'] = self.work_location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of manager
        if self.manager:
            _dict['manager'] = self.manager.to_dict()
        # override the default output from pydantic by calling `to_dict()` of group
        if self.group:
            _dict['group'] = self.group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in bank_accounts (list)
        _items = []
        if self.bank_accounts:
            for _item in self.bank_accounts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['bankAccounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in dependents (list)
        _items = []
        if self.dependents:
            for _item in self.dependents:
                if _item:
                    _items.append(_item.to_dict())
            _dict['dependents'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payroll_runs (list)
        _items = []
        if self.payroll_runs:
            for _item in self.payroll_runs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['payrollRuns'] = _items
        # override the default output from pydantic by calling `to_dict()` of pay_time_off_balance
        if self.pay_time_off_balance:
            _dict['payTimeOffBalance'] = self.pay_time_off_balance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in benefits (list)
        _items = []
        if self.benefits:
            for _item in self.benefits:
                if _item:
                    _items.append(_item.to_dict())
            _dict['benefits'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Employee from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "remoteId": obj.get("remoteId"),
            "employeeNumber": obj.get("employeeNumber"),
            "companyId": obj.get("companyId"),
            "firstName": obj.get("firstName"),
            "lastName": obj.get("lastName"),
            "employeesPreferredName": obj.get("employeesPreferredName"),
            "displayFullName": obj.get("displayFullName"),
            "employeeUserNameAsSeenInRemoteUi": obj.get("employeeUserNameAsSeenInRemoteUi"),
            "workEmail": obj.get("workEmail"),
            "personalEmail": obj.get("personalEmail"),
            "mobilePhoneNumber": obj.get("mobilePhoneNumber"),
            "employments": [EmployeeJobPositionAtCompany.from_dict(_item) for _item in obj["employments"]] if obj.get("employments") is not None else None,
            "employmentType": obj.get("employmentType"),
            "homeLocation": LocationAddress.from_dict(obj["homeLocation"]) if obj.get("homeLocation") is not None else None,
            "workLocation": LocationAddress.from_dict(obj["workLocation"]) if obj.get("workLocation") is not None else None,
            "manager": Employee.from_dict(obj["manager"]) if obj.get("manager") is not None else None,
            "group": Group.from_dict(obj["group"]) if obj.get("group") is not None else None,
            "ssn": obj.get("ssn"),
            "gender": obj.get("gender") if obj.get("gender") is not None else Gender.UNSPECIFIED,
            "ethnicity": obj.get("ethnicity") if obj.get("ethnicity") is not None else Ethnicity.UNSPECIFIED,
            "maritalStatus": obj.get("maritalStatus") if obj.get("maritalStatus") is not None else MaritalStatus.UNSPECIFIED,
            "dateOfBirth": obj.get("dateOfBirth"),
            "startDate": obj.get("startDate"),
            "remoteCreatedAt": obj.get("remoteCreatedAt"),
            "employmentStatus": obj.get("employmentStatus") if obj.get("employmentStatus") is not None else EmploymentStatus.UNSPECIFIED,
            "terminationDate": obj.get("terminationDate"),
            "avatar": obj.get("avatar"),
            "bankAccounts": [BankInfo.from_dict(_item) for _item in obj["bankAccounts"]] if obj.get("bankAccounts") is not None else None,
            "dependents": [Dependents.from_dict(_item) for _item in obj["dependents"]] if obj.get("dependents") is not None else None,
            "payrollRuns": [EmployeePayrollRun.from_dict(_item) for _item in obj["payrollRuns"]] if obj.get("payrollRuns") is not None else None,
            "payTimeOffBalance": EmployeTimeOffBalance.from_dict(obj["payTimeOffBalance"]) if obj.get("payTimeOffBalance") is not None else None,
            "benefits": [EmployeeBenefits.from_dict(_item) for _item in obj["benefits"]] if obj.get("benefits") is not None else None,
            "mergeAccountId": obj.get("mergeAccountId"),
            "createdAt": obj.get("createdAt"),
            "modifiedAt": obj.get("modifiedAt"),
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj

# TODO: Rewrite to not use raise_errors
Employee.model_rebuild(raise_errors=False)

