# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.dependent_relationship import DependentRelationship
from solomonai_backend_client_sdk.models.gender import Gender
from solomonai_backend_client_sdk.models.location_address import LocationAddress
from typing import Optional, Set
from typing_extensions import Self

class Dependents(BaseModel):
    """
    Dependents
    """ # noqa: E501
    id: Optional[StrictStr] = None
    remote_id: Optional[StrictStr] = Field(default=None, description="The third-party API ID of the matching object.", alias="remoteId")
    first_name: Optional[StrictStr] = Field(default=None, description="The employee's first name.", alias="firstName")
    last_name: Optional[StrictStr] = Field(default=None, description="The employee's last name.", alias="lastName")
    middle_name: Optional[StrictStr] = Field(default=None, alias="middleName")
    dependent_relationship_to_employee: Optional[DependentRelationship] = Field(default=DependentRelationship.UNSPECIFIED, alias="dependentRelationshipToEmployee")
    date_of_birth: Optional[datetime] = Field(default=None, description="The dependent's date of birth.", alias="dateOfBirth")
    gender: Optional[Gender] = Gender.UNSPECIFIED
    phone_number: Optional[StrictStr] = Field(default=None, alias="phoneNumber")
    home_location: Optional[LocationAddress] = Field(default=None, alias="homeLocation")
    is_student: Optional[StrictBool] = Field(default=None, alias="isStudent")
    ssn: Optional[StrictStr] = Field(default=None, description="The dependents's social security number.")
    remote_was_deleted: Optional[StrictBool] = Field(default=None, description="Indicates whether or not this object has been deleted in the third party platform.", alias="remoteWasDeleted")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    modified_at: Optional[datetime] = Field(default=None, alias="modifiedAt")
    merge_account_id: Optional[StrictStr] = Field(default=None, alias="mergeAccountId")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "remoteId", "firstName", "lastName", "middleName", "dependentRelationshipToEmployee", "dateOfBirth", "gender", "phoneNumber", "homeLocation", "isStudent", "ssn", "remoteWasDeleted", "createdAt", "modifiedAt", "mergeAccountId", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Dependents from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of home_location
        if self.home_location:
            _dict['homeLocation'] = self.home_location.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Dependents from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "remoteId": obj.get("remoteId"),
            "firstName": obj.get("firstName"),
            "lastName": obj.get("lastName"),
            "middleName": obj.get("middleName"),
            "dependentRelationshipToEmployee": obj.get("dependentRelationshipToEmployee") if obj.get("dependentRelationshipToEmployee") is not None else DependentRelationship.UNSPECIFIED,
            "dateOfBirth": obj.get("dateOfBirth"),
            "gender": obj.get("gender") if obj.get("gender") is not None else Gender.UNSPECIFIED,
            "phoneNumber": obj.get("phoneNumber"),
            "homeLocation": LocationAddress.from_dict(obj["homeLocation"]) if obj.get("homeLocation") is not None else None,
            "isStudent": obj.get("isStudent"),
            "ssn": obj.get("ssn"),
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "createdAt": obj.get("createdAt"),
            "modifiedAt": obj.get("modifiedAt"),
            "mergeAccountId": obj.get("mergeAccountId"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


