# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from solomonai_backend_client_sdk.models.credit_note_line_item import CreditNoteLineItem
from typing import Optional, Set
from typing_extensions import Self

class CreditNote(BaseModel):
    """
    A CreditNote is transaction issued to a customer, indicating a reduction or cancellation of the amount owed by the customer. It is most generally used as an adjustment note used to rectify errors, returns, or overpayments related to a sales transaction. A CreditNote can be applied to Accounts Receivable Invoices to decrease the overall amount of the Invoice.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    remote_id: Optional[StrictStr] = Field(default=None, description="The third-party API ID of the matching object.", alias="remoteId")
    transaction_date: Optional[datetime] = Field(default=None, description="The credit note's transaction date.  Consider using google.protobuf.Timestamp", alias="transactionDate")
    status: Optional[StrictStr] = Field(default=None, description="The credit note's status.")
    number: Optional[StrictStr] = Field(default=None, description="The credit note's number.")
    contact: Optional[StrictStr] = Field(default=None, description="The credit note's contact.")
    company: Optional[StrictStr] = Field(default=None, description="The company the credit note belongs to.")
    exchange_rate: Optional[StrictStr] = Field(default=None, description="The credit note's exchange rate.  Consider using double or float if this represents a number", alias="exchangeRate")
    total_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The credit note's total amount.", alias="totalAmount")
    remaining_credit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The amount of value remaining in the credit note that the customer can use.", alias="remainingCredit")
    line_items: Optional[List[CreditNoteLineItem]] = Field(default=None, alias="lineItems")
    tracking_categories: Optional[List[StrictStr]] = Field(default=None, alias="trackingCategories")
    currency: Optional[StrictStr] = None
    remote_created_at: Optional[datetime] = Field(default=None, alias="remoteCreatedAt")
    remote_updated_at: Optional[datetime] = Field(default=None, alias="remoteUpdatedAt")
    payment_ids: Optional[List[StrictStr]] = Field(default=None, description="These are IDs", alias="paymentIds")
    remote_was_deleted: Optional[StrictBool] = Field(default=None, alias="remoteWasDeleted")
    accounting_period: Optional[StrictStr] = Field(default=None, description="The accounting period that the CreditNote was generated in.", alias="accountingPeriod")
    modified_at: Optional[datetime] = Field(default=None, alias="modifiedAt")
    merge_record_id: Optional[StrictStr] = Field(default=None, alias="mergeRecordId")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "remoteId", "transactionDate", "status", "number", "contact", "company", "exchangeRate", "totalAmount", "remainingCredit", "lineItems", "trackingCategories", "currency", "remoteCreatedAt", "remoteUpdatedAt", "paymentIds", "remoteWasDeleted", "accountingPeriod", "modifiedAt", "mergeRecordId", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreditNote from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in line_items (list)
        _items = []
        if self.line_items:
            for _item in self.line_items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['lineItems'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreditNote from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "remoteId": obj.get("remoteId"),
            "transactionDate": obj.get("transactionDate"),
            "status": obj.get("status"),
            "number": obj.get("number"),
            "contact": obj.get("contact"),
            "company": obj.get("company"),
            "exchangeRate": obj.get("exchangeRate"),
            "totalAmount": obj.get("totalAmount"),
            "remainingCredit": obj.get("remainingCredit"),
            "lineItems": [CreditNoteLineItem.from_dict(_item) for _item in obj["lineItems"]] if obj.get("lineItems") is not None else None,
            "trackingCategories": obj.get("trackingCategories"),
            "currency": obj.get("currency"),
            "remoteCreatedAt": obj.get("remoteCreatedAt"),
            "remoteUpdatedAt": obj.get("remoteUpdatedAt"),
            "paymentIds": obj.get("paymentIds"),
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "accountingPeriod": obj.get("accountingPeriod"),
            "modifiedAt": obj.get("modifiedAt"),
            "mergeRecordId": obj.get("mergeRecordId"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


