# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from solomonai_backend_client_sdk.models.account_statements import AccountStatements
from solomonai_backend_client_sdk.models.apr import Apr
from solomonai_backend_client_sdk.models.bank_account_status import BankAccountStatus
from solomonai_backend_client_sdk.models.bank_account_type import BankAccountType
from solomonai_backend_client_sdk.models.plaid_account_recurring_transaction import PlaidAccountRecurringTransaction
from solomonai_backend_client_sdk.models.plaid_account_transaction import PlaidAccountTransaction
from solomonai_backend_client_sdk.models.pocket import Pocket
from typing import Optional, Set
from typing_extensions import Self

class CreditAccount(BaseModel):
    """
    CreditAccount
    """ # noqa: E501
    id: Optional[StrictStr] = None
    user_id: Optional[StrictStr] = Field(default=None, alias="userId")
    name: Optional[StrictStr] = None
    number: Optional[StrictStr] = None
    type: Optional[BankAccountType] = BankAccountType.UNSPECIFIED
    balance: Optional[Union[StrictFloat, StrictInt]] = None
    current_funds: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="currentFunds")
    balance_limit: Optional[StrictStr] = Field(default=None, alias="balanceLimit")
    plaid_account_id: Optional[StrictStr] = Field(default=None, alias="plaidAccountId")
    subtype: Optional[StrictStr] = None
    is_overdue: Optional[StrictBool] = Field(default=None, alias="isOverdue")
    last_payment_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="lastPaymentAmount")
    last_payment_date: Optional[StrictStr] = Field(default=None, alias="lastPaymentDate")
    last_statement_issue_date: Optional[StrictStr] = Field(default=None, alias="lastStatementIssueDate")
    minimum_amount_due_date: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="minimumAmountDueDate")
    next_payment_date: Optional[StrictStr] = Field(default=None, alias="nextPaymentDate")
    aprs: Optional[List[Apr]] = None
    last_statement_balance: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="lastStatementBalance")
    minimum_payment_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="minimumPaymentAmount")
    next_payment_due_date: Optional[StrictStr] = Field(default=None, alias="nextPaymentDueDate")
    status: Optional[BankAccountStatus] = BankAccountStatus.UNSPECIFIED
    transactions: Optional[List[PlaidAccountTransaction]] = None
    recurring_transactions: Optional[List[PlaidAccountRecurringTransaction]] = Field(default=None, alias="recurringTransactions")
    pockets: Optional[List[Pocket]] = None
    statements: Optional[List[AccountStatements]] = None
    plaid_account_type: Optional[StrictStr] = Field(default=None, alias="plaidAccountType")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "userId", "name", "number", "type", "balance", "currentFunds", "balanceLimit", "plaidAccountId", "subtype", "isOverdue", "lastPaymentAmount", "lastPaymentDate", "lastStatementIssueDate", "minimumAmountDueDate", "nextPaymentDate", "aprs", "lastStatementBalance", "minimumPaymentAmount", "nextPaymentDueDate", "status", "transactions", "recurringTransactions", "pockets", "statements", "plaidAccountType", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreditAccount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in aprs (list)
        _items = []
        if self.aprs:
            for _item in self.aprs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['aprs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in transactions (list)
        _items = []
        if self.transactions:
            for _item in self.transactions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['transactions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in recurring_transactions (list)
        _items = []
        if self.recurring_transactions:
            for _item in self.recurring_transactions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['recurringTransactions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in pockets (list)
        _items = []
        if self.pockets:
            for _item in self.pockets:
                if _item:
                    _items.append(_item.to_dict())
            _dict['pockets'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in statements (list)
        _items = []
        if self.statements:
            for _item in self.statements:
                if _item:
                    _items.append(_item.to_dict())
            _dict['statements'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreditAccount from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "userId": obj.get("userId"),
            "name": obj.get("name"),
            "number": obj.get("number"),
            "type": obj.get("type") if obj.get("type") is not None else BankAccountType.UNSPECIFIED,
            "balance": obj.get("balance"),
            "currentFunds": obj.get("currentFunds"),
            "balanceLimit": obj.get("balanceLimit"),
            "plaidAccountId": obj.get("plaidAccountId"),
            "subtype": obj.get("subtype"),
            "isOverdue": obj.get("isOverdue"),
            "lastPaymentAmount": obj.get("lastPaymentAmount"),
            "lastPaymentDate": obj.get("lastPaymentDate"),
            "lastStatementIssueDate": obj.get("lastStatementIssueDate"),
            "minimumAmountDueDate": obj.get("minimumAmountDueDate"),
            "nextPaymentDate": obj.get("nextPaymentDate"),
            "aprs": [Apr.from_dict(_item) for _item in obj["aprs"]] if obj.get("aprs") is not None else None,
            "lastStatementBalance": obj.get("lastStatementBalance"),
            "minimumPaymentAmount": obj.get("minimumPaymentAmount"),
            "nextPaymentDueDate": obj.get("nextPaymentDueDate"),
            "status": obj.get("status") if obj.get("status") is not None else BankAccountStatus.UNSPECIFIED,
            "transactions": [PlaidAccountTransaction.from_dict(_item) for _item in obj["transactions"]] if obj.get("transactions") is not None else None,
            "recurringTransactions": [PlaidAccountRecurringTransaction.from_dict(_item) for _item in obj["recurringTransactions"]] if obj.get("recurringTransactions") is not None else None,
            "pockets": [Pocket.from_dict(_item) for _item in obj["pockets"]] if obj.get("pockets") is not None else None,
            "statements": [AccountStatements.from_dict(_item) for _item in obj["statements"]] if obj.get("statements") is not None else None,
            "plaidAccountType": obj.get("plaidAccountType"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


