# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.financial_user_profile_type import FinancialUserProfileType
from typing import Optional, Set
from typing_extensions import Self

class CreateUserProfileResponse1(BaseModel):
    """
    CreateUserProfileResponse represents the response object returned after a successful user profile creation request. This message encapsulates the essential information that confirms the creation of a new financial user profile.
    """ # noqa: E501
    supabase_auth_user_id: Optional[StrictStr] = Field(default=None, description="The same supabase user ID that was provided in the request. This ID can be used for future operations and queries related to this financial profile.  @output This field is populated by the server upon successful profile creation. @example \"fp_1234567890abcdef\"", alias="supabaseAuthUserId")
    user_id: Optional[StrictStr] = Field(default=None, description="The unique identifier for the record.  @output This field is populated by the server upon successful profile creation. @example \"1000\"", alias="userId")
    created_at: Optional[datetime] = Field(default=None, description="Timestamp of financial user profile creation", alias="createdAt")
    profile_type: Optional[FinancialUserProfileType] = Field(default=FinancialUserProfileType.UNSPECIFIED, alias="profileType")
    __properties: ClassVar[List[str]] = ["supabaseAuthUserId", "userId", "createdAt", "profileType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateUserProfileResponse1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateUserProfileResponse1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "supabaseAuthUserId": obj.get("supabaseAuthUserId"),
            "userId": obj.get("userId"),
            "createdAt": obj.get("createdAt"),
            "profileType": obj.get("profileType") if obj.get("profileType") is not None else FinancialUserProfileType.UNSPECIFIED
        })
        return _obj


