# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.company_address import CompanyAddress
from typing import Optional, Set
from typing_extensions import Self

class CompanyInfo(BaseModel):
    """
    The CompanyInfo object is used to represent a company's information.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    remote_id: Optional[StrictStr] = Field(default=None, description="The third-party API ID of the matching object.", alias="remoteId")
    name: Optional[StrictStr] = Field(default=None, description="The company's name.")
    legal_name: Optional[StrictStr] = Field(default=None, description="The company's legal name.", alias="legalName")
    tax_number: Optional[StrictStr] = Field(default=None, description="The company's tax number.", alias="taxNumber")
    fiscal_year_end_month: Optional[StrictInt] = Field(default=None, description="The company's fiscal year end month.", alias="fiscalYearEndMonth")
    fiscal_year_end_day: Optional[StrictInt] = Field(default=None, description="The company's fiscal year end day.", alias="fiscalYearEndDay")
    currency: Optional[StrictStr] = Field(default=None, description="The currency set in the company's accounting platform.")
    remote_created_at: Optional[datetime] = Field(default=None, description="When the third party's company was created.  Consider using google.protobuf.Timestamp", alias="remoteCreatedAt")
    urls: Optional[List[StrictStr]] = Field(default=None, description="The company's urls.")
    addresses: Optional[List[CompanyAddress]] = None
    phone_numbers: Optional[List[StrictStr]] = Field(default=None, alias="phoneNumbers")
    remote_was_deleted: Optional[StrictBool] = Field(default=None, description="Indicates whether or not this object has been deleted by third party webhooks.", alias="remoteWasDeleted")
    modified_at: Optional[datetime] = Field(default=None, alias="modifiedAt")
    merge_record_id: Optional[StrictStr] = Field(default=None, alias="mergeRecordId")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "remoteId", "name", "legalName", "taxNumber", "fiscalYearEndMonth", "fiscalYearEndDay", "currency", "remoteCreatedAt", "urls", "addresses", "phoneNumbers", "remoteWasDeleted", "modifiedAt", "mergeRecordId", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CompanyInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in addresses (list)
        _items = []
        if self.addresses:
            for _item in self.addresses:
                if _item:
                    _items.append(_item.to_dict())
            _dict['addresses'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CompanyInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "remoteId": obj.get("remoteId"),
            "name": obj.get("name"),
            "legalName": obj.get("legalName"),
            "taxNumber": obj.get("taxNumber"),
            "fiscalYearEndMonth": obj.get("fiscalYearEndMonth"),
            "fiscalYearEndDay": obj.get("fiscalYearEndDay"),
            "currency": obj.get("currency"),
            "remoteCreatedAt": obj.get("remoteCreatedAt"),
            "urls": obj.get("urls"),
            "addresses": [CompanyAddress.from_dict(_item) for _item in obj["addresses"]] if obj.get("addresses") is not None else None,
            "phoneNumbers": obj.get("phoneNumbers"),
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "modifiedAt": obj.get("modifiedAt"),
            "mergeRecordId": obj.get("mergeRecordId"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


