# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.comment_edit import CommentEdit
from typing import Optional, Set
from typing_extensions import Self

class Comment1(BaseModel):
    """
    Comment represents a single comment in a thread.  Features: - User attribution - Content handling - Timestamps - Comment status
    """ # noqa: E501
    id: Optional[StrictStr] = None
    thread_id: Optional[StrictStr] = Field(default=None, alias="threadId")
    tenant_id: Optional[StrictStr] = Field(default=None, alias="tenantId")
    author_name: Optional[StrictStr] = Field(default=None, alias="authorName")
    content: Optional[StrictStr] = None
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    parent_comment_id: Optional[StrictStr] = Field(default=None, alias="parentCommentId")
    status: Optional[StrictStr] = None
    reactions: Optional[Dict[str, StrictInt]] = None
    edits: Optional[List[CommentEdit]] = None
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    tags: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["id", "threadId", "tenantId", "authorName", "content", "createdAt", "updatedAt", "parentCommentId", "status", "reactions", "edits", "deletedAt", "tags"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Comment1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in edits (list)
        _items = []
        if self.edits:
            for _item in self.edits:
                if _item:
                    _items.append(_item.to_dict())
            _dict['edits'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Comment1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "threadId": obj.get("threadId"),
            "tenantId": obj.get("tenantId"),
            "authorName": obj.get("authorName"),
            "content": obj.get("content"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "parentCommentId": obj.get("parentCommentId"),
            "status": obj.get("status"),
            "reactions": obj.get("reactions"),
            "edits": [CommentEdit.from_dict(_item) for _item in obj["edits"]] if obj.get("edits") is not None else None,
            "deletedAt": obj.get("deletedAt"),
            "tags": obj.get("tags")
        })
        return _obj


