# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from solomonai_backend_client_sdk.models.report_item import ReportItem
from typing import Optional, Set
from typing_extensions import Self

class CashFlowStatement(BaseModel):
    """
    The CashFlowStatement object shows operating activities, investing activities, and financing activities over a period of time (month, quarter, or year).
    """ # noqa: E501
    id: Optional[StrictStr] = None
    remote_id: Optional[StrictStr] = Field(default=None, description="The third-party API ID of the matching object.", alias="remoteId")
    name: Optional[StrictStr] = Field(default=None, description="The cash flow statement's name.")
    currency: Optional[StrictStr] = None
    company: Optional[StrictStr] = Field(default=None, description="The company the cash flow statement belongs to.")
    start_period: Optional[datetime] = Field(default=None, description="The cash flow statement's start period.  Consider using google.protobuf.Timestamp", alias="startPeriod")
    end_period: Optional[datetime] = Field(default=None, description="The cash flow statement's end period.  Consider using google.protobuf.Timestamp", alias="endPeriod")
    cash_at_beginning_of_period: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Cash and cash equivalents at the beginning of the cash flow statement's period.", alias="cashAtBeginningOfPeriod")
    cash_at_end_of_period: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Cash and cash equivalents at the beginning of the cash flow statement's period.", alias="cashAtEndOfPeriod")
    operating_activities: Optional[List[ReportItem]] = Field(default=None, alias="operatingActivities")
    investing_activities: Optional[List[ReportItem]] = Field(default=None, alias="investingActivities")
    financing_activities: Optional[List[ReportItem]] = Field(default=None, alias="financingActivities")
    remote_generated_at: Optional[datetime] = Field(default=None, description="The time that cash flow statement was generated by the accounting system.  Consider using google.protobuf.Timestamp", alias="remoteGeneratedAt")
    remote_was_deleted: Optional[StrictBool] = Field(default=None, description="Indicates whether or not this object has been deleted by third party webhooks.", alias="remoteWasDeleted")
    modified_at: Optional[datetime] = Field(default=None, description="Consider using google.protobuf.Timestamp", alias="modifiedAt")
    merge_record_id: Optional[StrictStr] = Field(default=None, alias="mergeRecordId")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "remoteId", "name", "currency", "company", "startPeriod", "endPeriod", "cashAtBeginningOfPeriod", "cashAtEndOfPeriod", "operatingActivities", "investingActivities", "financingActivities", "remoteGeneratedAt", "remoteWasDeleted", "modifiedAt", "mergeRecordId", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CashFlowStatement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in operating_activities (list)
        _items = []
        if self.operating_activities:
            for _item in self.operating_activities:
                if _item:
                    _items.append(_item.to_dict())
            _dict['operatingActivities'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in investing_activities (list)
        _items = []
        if self.investing_activities:
            for _item in self.investing_activities:
                if _item:
                    _items.append(_item.to_dict())
            _dict['investingActivities'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in financing_activities (list)
        _items = []
        if self.financing_activities:
            for _item in self.financing_activities:
                if _item:
                    _items.append(_item.to_dict())
            _dict['financingActivities'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CashFlowStatement from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "remoteId": obj.get("remoteId"),
            "name": obj.get("name"),
            "currency": obj.get("currency"),
            "company": obj.get("company"),
            "startPeriod": obj.get("startPeriod"),
            "endPeriod": obj.get("endPeriod"),
            "cashAtBeginningOfPeriod": obj.get("cashAtBeginningOfPeriod"),
            "cashAtEndOfPeriod": obj.get("cashAtEndOfPeriod"),
            "operatingActivities": [ReportItem.from_dict(_item) for _item in obj["operatingActivities"]] if obj.get("operatingActivities") is not None else None,
            "investingActivities": [ReportItem.from_dict(_item) for _item in obj["investingActivities"]] if obj.get("investingActivities") is not None else None,
            "financingActivities": [ReportItem.from_dict(_item) for _item in obj["financingActivities"]] if obj.get("financingActivities") is not None else None,
            "remoteGeneratedAt": obj.get("remoteGeneratedAt"),
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "modifiedAt": obj.get("modifiedAt"),
            "mergeRecordId": obj.get("mergeRecordId"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


