# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class BusinessChartOfAccount(BaseModel):
    """
    The Account object is what companies use to track transactions. They can be both bank accounts or a general ledger account (also called a chart of accounts).  Note: a company can have a multitude of these accounts
    """ # noqa: E501
    id: Optional[StrictStr] = None
    merge_record_id: StrictStr = Field(alias="mergeRecordId")
    remote_id: Optional[StrictStr] = Field(default=None, alias="remoteId")
    name: Optional[StrictStr] = Field(default=None, description="The account's name.")
    description: Optional[StrictStr] = Field(default=None, description="The account's description.")
    classification: Optional[StrictStr] = Field(default=None, description="The account's broadest grouping. Possible values include: ASSET, EQUITY, EXPENSE, LIABILITY, REVENUE. In cases where there is no clear mapping, the original value passed through will be returned.")
    type: Optional[StrictStr] = Field(default=None, description="The account's type is a narrower and more specific grouping within the account's classification.")
    status: Optional[StrictStr] = Field(default=None, description="The account's status. Possible values include: ACTIVE, PENDING, INACTIVE. In cases where there is  no clear mapping, the original value passed through will be returned.")
    current_balance: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The account's current balance.", alias="currentBalance")
    currency: Optional[StrictStr] = None
    account_number: Optional[StrictStr] = Field(default=None, description="The account's number.", alias="accountNumber")
    parent_account_id: Optional[StrictStr] = Field(default=None, description="ID of the parent account.", alias="parentAccountId")
    company: Optional[StrictStr] = Field(default=None, description="The company the account belongs to.")
    modified_at: Optional[datetime] = Field(default=None, alias="modifiedAt")
    remote_was_deleted: Optional[StrictBool] = Field(default=None, description="Indicates whether or not this object has been deleted by third party webhooks.", alias="remoteWasDeleted")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "mergeRecordId", "remoteId", "name", "description", "classification", "type", "status", "currentBalance", "currency", "accountNumber", "parentAccountId", "company", "modifiedAt", "remoteWasDeleted", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BusinessChartOfAccount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BusinessChartOfAccount from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "mergeRecordId": obj.get("mergeRecordId"),
            "remoteId": obj.get("remoteId"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "classification": obj.get("classification"),
            "type": obj.get("type"),
            "status": obj.get("status"),
            "currentBalance": obj.get("currentBalance"),
            "currency": obj.get("currency"),
            "accountNumber": obj.get("accountNumber"),
            "parentAccountId": obj.get("parentAccountId"),
            "company": obj.get("company"),
            "modifiedAt": obj.get("modifiedAt"),
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


